/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.junit;

import java.util.Map;
import org.apache.maven.shadefire.surefire.api.provider.AbstractProvider;
import org.apache.maven.shadefire.surefire.api.provider.ProviderParameters;
import org.apache.maven.shadefire.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.shadefire.surefire.api.report.ReporterFactory;
import org.apache.maven.shadefire.surefire.api.report.RunMode;
import org.apache.maven.shadefire.surefire.api.report.SimpleReportEntry;
import org.apache.maven.shadefire.surefire.api.suite.RunResult;
import org.apache.maven.shadefire.surefire.api.testset.TestSetFailedException;
import org.apache.maven.shadefire.surefire.api.util.ReflectionUtils;
import org.apache.maven.shadefire.surefire.api.util.RunOrderCalculator;
import org.apache.maven.shadefire.surefire.api.util.ScanResult;
import org.apache.maven.shadefire.surefire.api.util.TestsToRun;
import org.apache.maven.shadefire.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.shadefire.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.shadefire.surefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.shadefire.surefire.junit.JUnit3Reporter;
import org.apache.maven.shadefire.surefire.junit.JUnitTestSetExecutor;
import org.apache.maven.shadefire.surefire.junit.PojoAndJUnit3Checker;
import org.apache.maven.shadefire.surefire.junit.PojoTestSetExecutor;
import org.apache.maven.shadefire.surefire.junit.SurefireTestSetExecutor;

public class JUnit3Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final PojoAndJUnit3Checker testChecker;
    private final JUnit3TestChecker jUnit3TestChecker;
    private final JUnit3Reflector reflector;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;

    public JUnit3Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.scanResult = booterParameters.getScanResult();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.reflector = new JUnit3Reflector(this.testClassLoader);
        this.jUnit3TestChecker = new JUnit3TestChecker(this.testClassLoader);
        this.testChecker = new PojoAndJUnit3Checker(this.jUnit3TestChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        JUnit3Reporter reporter = new JUnit3Reporter(reporterFactory.createTestReportListener());
        reporter.setRunMode(RunMode.NORMAL_RUN);
        ConsoleOutputCapture.startCapture(reporter);
        TestsToRun testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)forkTestSet) : this.scanClassPath());
        try {
            Map<String, String> systemProperties = ObjectUtils.systemProps();
            JUnit3Provider.setSystemManager(System.getProperty("surefire.security.manager"));
            for (Class<?> clazz : testsToRun) {
                SurefireTestSetExecutor surefireTestSetExecutor = this.createTestSet(clazz, reporter);
                this.executeTestSet(clazz, surefireTestSetExecutor, reporter, systemProperties);
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    static void setSystemManager(String smClassName) throws TestSetFailedException {
        if (smClassName != null) {
            if (!ObjectUtils.isSecurityManagerSupported()) {
                throw new TestSetFailedException("JDK does not support overriding Security Manager with a value in system property 'surefire.security.manager'.");
            }
            ClassLoader classLoader = JUnit3Provider.class.getClassLoader();
            SecurityManager sm = ReflectionUtils.instantiate(classLoader, smClassName, SecurityManager.class);
            System.setSecurityManager(sm);
        }
    }

    private SurefireTestSetExecutor createTestSet(Class<?> clazz, JUnit3Reporter reporter) {
        return this.reflector.isJUnit3Available() && this.jUnit3TestChecker.accept(clazz) ? new JUnitTestSetExecutor(this.reflector, reporter) : new PojoTestSetExecutor(reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> testSet, SurefireTestSetExecutor testSetExecutor, JUnit3Reporter reporter, Map<String, String> systemProperties) throws TestSetFailedException {
        String clazz = testSet.getName();
        long testId = reporter.getClassMethodIndexer().indexClass(clazz);
        try {
            SimpleReportEntry started = new SimpleReportEntry(RunMode.NORMAL_RUN, testId, clazz, null, null, null);
            reporter.testSetStarting(started);
            testSetExecutor.execute(testSet, this.testClassLoader);
        }
        finally {
            SimpleReportEntry completed = new SimpleReportEntry(RunMode.NORMAL_RUN, (Long)testId, clazz, null, null, null, systemProperties);
            reporter.testSetCompleted(completed);
        }
    }

    private TestsToRun scanClassPath() {
        TestsToRun testsToRun = this.scanResult.applyFilter(this.testChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(testsToRun);
    }

    @Override
    public Iterable<Class<?>> getSuites() {
        return this.scanClassPath();
    }
}

