/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.testset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.shadefire.surefire.api.testset.GenericTestPattern;
import org.apache.maven.shadefire.surefire.api.testset.IncludedExcludedPatterns;
import org.apache.maven.shadefire.surefire.api.testset.ResolvedTest;
import org.apache.maven.shadefire.surefire.api.testset.TestFilter;
import org.apache.maven.shadefire.surefire.shared.utils.StringUtils;

public class TestListResolver
implements GenericTestPattern<ResolvedTest, String, String> {
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private static final TestListResolver WILDCARD = new TestListResolver("*.class");
    private static final TestListResolver EMPTY = new TestListResolver("");
    private final Set<ResolvedTest> includedPatterns;
    private final Set<ResolvedTest> excludedPatterns;
    private final boolean hasIncludedMethodPatterns;
    private final boolean hasExcludedMethodPatterns;

    public TestListResolver(Collection<String> tests) {
        IncludedExcludedPatterns patterns = new IncludedExcludedPatterns();
        LinkedHashSet<ResolvedTest> includedFilters = new LinkedHashSet<ResolvedTest>(0);
        LinkedHashSet<ResolvedTest> excludedFilters = new LinkedHashSet<ResolvedTest>(0);
        for (String csvTests : tests) {
            if (!StringUtils.isNotBlank(csvTests)) continue;
            for (String request : StringUtils.split(csvTests, ",")) {
                if ((request = request.trim()).isEmpty() || request.equals("!")) continue;
                TestListResolver.resolveTestRequest(request, patterns, includedFilters, excludedFilters);
            }
        }
        this.includedPatterns = Collections.unmodifiableSet(includedFilters);
        this.excludedPatterns = Collections.unmodifiableSet(excludedFilters);
        this.hasIncludedMethodPatterns = patterns.hasIncludedMethodPatterns;
        this.hasExcludedMethodPatterns = patterns.hasExcludedMethodPatterns;
    }

    public TestListResolver(String csvTests) {
        this(csvTests == null ? Collections.emptySet() : Collections.singleton(csvTests));
    }

    public TestListResolver(Collection<String> included, Collection<String> excluded) {
        this(TestListResolver.mergeIncludedAndExcludedTests(included, excluded));
    }

    private TestListResolver(boolean hasIncludedMethodPatterns, boolean hasExcludedMethodPatterns, Set<ResolvedTest> includedPatterns, Set<ResolvedTest> excludedPatterns) {
        this.includedPatterns = includedPatterns;
        this.excludedPatterns = excludedPatterns;
        this.hasIncludedMethodPatterns = hasIncludedMethodPatterns;
        this.hasExcludedMethodPatterns = hasExcludedMethodPatterns;
    }

    public static TestListResolver newTestListResolver(Set<ResolvedTest> includedPatterns, Set<ResolvedTest> excludedPatterns) {
        return new TestListResolver(TestListResolver.haveMethodPatterns(includedPatterns), TestListResolver.haveMethodPatterns(excludedPatterns), includedPatterns, excludedPatterns);
    }

    @Override
    public boolean hasIncludedMethodPatterns() {
        return this.hasIncludedMethodPatterns;
    }

    @Override
    public boolean hasExcludedMethodPatterns() {
        return this.hasExcludedMethodPatterns;
    }

    @Override
    public boolean hasMethodPatterns() {
        return this.hasIncludedMethodPatterns() || this.hasExcludedMethodPatterns();
    }

    public static TestListResolver optionallyWildcardFilter(TestListResolver resolver) {
        return resolver.hasMethodPatterns() ? resolver : WILDCARD;
    }

    public static TestListResolver getEmptyTestListResolver() {
        return EMPTY;
    }

    public final boolean isWildcard() {
        return this.equals(WILDCARD);
    }

    public TestFilter<String, String> and(final TestListResolver another) {
        return new TestFilter<String, String>(){

            @Override
            public boolean shouldRun(String testClass, String methodName) {
                return TestListResolver.this.shouldRun(testClass, methodName) && another.shouldRun(testClass, methodName);
            }
        };
    }

    public TestFilter<String, String> or(final TestListResolver another) {
        return new TestFilter<String, String>(){

            @Override
            public boolean shouldRun(String testClass, String methodName) {
                return TestListResolver.this.shouldRun(testClass, methodName) || another.shouldRun(testClass, methodName);
            }
        };
    }

    @Override
    public boolean shouldRun(Class<?> testClass, String methodName) {
        return this.shouldRun(TestListResolver.toClassFileName(testClass), methodName);
    }

    @Override
    public boolean shouldRun(String testClassFile, String methodName) {
        if (this.isEmpty() || StringUtils.isBlank(testClassFile) && StringUtils.isBlank(methodName)) {
            return true;
        }
        boolean shouldRun = false;
        if (this.getIncludedPatterns().isEmpty()) {
            shouldRun = true;
        } else {
            for (ResolvedTest filter : this.getIncludedPatterns()) {
                if (!filter.matchAsInclusive(testClassFile, methodName)) continue;
                shouldRun = true;
                break;
            }
        }
        if (shouldRun) {
            for (ResolvedTest filter : this.getExcludedPatterns()) {
                if (!filter.matchAsExclusive(testClassFile, methodName)) continue;
                shouldRun = false;
                break;
            }
        }
        return shouldRun;
    }

    @Override
    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    @Override
    public String getPluginParameterTest() {
        String aggregatedTest = TestListResolver.aggregatedTest("", this.getIncludedPatterns());
        if (StringUtils.isNotBlank(aggregatedTest) && !this.getExcludedPatterns().isEmpty()) {
            aggregatedTest = aggregatedTest + ", ";
        }
        return (aggregatedTest = aggregatedTest + TestListResolver.aggregatedTest("!", this.getExcludedPatterns())).isEmpty() ? "" : aggregatedTest;
    }

    @Override
    public Set<ResolvedTest> getIncludedPatterns() {
        return this.includedPatterns;
    }

    @Override
    public Set<ResolvedTest> getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestListResolver that = (TestListResolver)o;
        return this.getIncludedPatterns().equals(that.getIncludedPatterns()) && this.getExcludedPatterns().equals(that.getExcludedPatterns());
    }

    public int hashCode() {
        int result = this.getIncludedPatterns().hashCode();
        result = 31 * result + this.getExcludedPatterns().hashCode();
        return result;
    }

    public String toString() {
        return this.getPluginParameterTest();
    }

    public static String toClassFileName(Class<?> test) {
        return test == null ? null : TestListResolver.toClassFileName(test.getName());
    }

    public static String toClassFileName(String fullyQualifiedTestClass) {
        return fullyQualifiedTestClass == null ? null : fullyQualifiedTestClass.replace('.', '/') + JAVA_CLASS_FILE_EXTENSION;
    }

    static String removeExclamationMark(String s) {
        return !s.isEmpty() && s.charAt(0) == '!' ? s.substring(1) : s;
    }

    private static void updatedFilters(boolean isExcluded, ResolvedTest test, IncludedExcludedPatterns patterns, Collection<ResolvedTest> includedFilters, Collection<ResolvedTest> excludedFilters) {
        if (isExcluded) {
            excludedFilters.add(test);
            patterns.hasExcludedMethodPatterns |= test.hasTestMethodPattern();
        } else {
            includedFilters.add(test);
            patterns.hasIncludedMethodPatterns |= test.hasTestMethodPattern();
        }
    }

    private static String aggregatedTest(String testPrefix, Set<ResolvedTest> tests) {
        StringBuilder aggregatedTest = new StringBuilder();
        for (ResolvedTest test : tests) {
            String readableTest = test.toString();
            if (readableTest.isEmpty()) continue;
            if (aggregatedTest.length() != 0) {
                aggregatedTest.append(", ");
            }
            aggregatedTest.append(testPrefix).append(readableTest);
        }
        return aggregatedTest.toString();
    }

    private static Collection<String> mergeIncludedAndExcludedTests(Collection<String> included, Collection<String> excluded) {
        ArrayList<String> incExc = new ArrayList<String>(included);
        incExc.removeAll(Collections.singleton(null));
        for (String exc : excluded) {
            if (exc == null || (exc = exc.trim()).isEmpty()) continue;
            if (exc.contains("!")) {
                throw new IllegalArgumentException("Exclamation mark not expected in 'exclusion': " + exc);
            }
            if (!(exc = exc.replace(",", ",!")).startsWith("!")) {
                exc = "!" + exc;
            }
            incExc.add(exc);
        }
        return incExc;
    }

    static boolean isRegexPrefixedPattern(String pattern) {
        int indexOfRegex = pattern.indexOf("%regex[");
        int prefixLength = "%regex[".length();
        if (indexOfRegex != -1) {
            if (indexOfRegex != 0 || !pattern.endsWith("]") || !TestListResolver.isRegexMinLength(pattern) || pattern.indexOf("%regex[", prefixLength) != -1) {
                String msg = "Illegal test|includes|excludes regex '%s'. Expected %%regex[class#method] or !%%regex[class#method] with optional class or #method.";
                throw new IllegalArgumentException(String.format(msg, pattern));
            }
            return true;
        }
        return false;
    }

    static boolean isRegexMinLength(String pattern) {
        return pattern.length() > "%regex[".length() + "]".length() + 1;
    }

    static String[] unwrapRegex(String regex) {
        regex = regex.trim();
        int from = "%regex[".length();
        int to = regex.length() - "]".length();
        return TestListResolver.unwrap(regex.substring(from, to));
    }

    static String[] unwrap(String request) {
        String[] classAndMethod = new String[]{"", ""};
        int indexOfHash = request.indexOf(35);
        if (indexOfHash == -1) {
            classAndMethod[0] = request.trim();
        } else {
            classAndMethod[0] = request.substring(0, indexOfHash).trim();
            classAndMethod[1] = request.substring(1 + indexOfHash).trim();
        }
        return classAndMethod;
    }

    static void nonRegexClassAndMethods(String clazz, String methods, boolean isExcluded, IncludedExcludedPatterns patterns, Collection<ResolvedTest> includedFilters, Collection<ResolvedTest> excludedFilters) {
        for (String method : StringUtils.split(methods, "+")) {
            ResolvedTest test = new ResolvedTest(clazz, method = method.trim(), false);
            if (test.isEmpty()) continue;
            TestListResolver.updatedFilters(isExcluded, test, patterns, includedFilters, excludedFilters);
        }
    }

    static void resolveTestRequest(String request, IncludedExcludedPatterns patterns, Collection<ResolvedTest> includedFilters, Collection<ResolvedTest> excludedFilters) {
        boolean isExcluded = request.startsWith("!");
        ResolvedTest test = null;
        if (TestListResolver.isRegexPrefixedPattern(request = TestListResolver.removeExclamationMark(request))) {
            boolean hasMethod;
            String[] unwrapped = TestListResolver.unwrapRegex(request);
            boolean hasClass = !unwrapped[0].isEmpty();
            boolean bl = hasMethod = !unwrapped[1].isEmpty();
            if (hasClass && hasMethod) {
                test = new ResolvedTest(unwrapped[0], unwrapped[1], true);
            } else if (hasClass) {
                test = new ResolvedTest(ResolvedTest.Type.CLASS, unwrapped[0], true);
            } else if (hasMethod) {
                test = new ResolvedTest(ResolvedTest.Type.METHOD, unwrapped[1], true);
            }
        } else {
            int indexOfMethodSeparator = request.indexOf(35);
            if (indexOfMethodSeparator == -1) {
                test = new ResolvedTest(ResolvedTest.Type.CLASS, request, false);
            } else {
                String clazz = request.substring(0, indexOfMethodSeparator);
                String methods = request.substring(1 + indexOfMethodSeparator);
                TestListResolver.nonRegexClassAndMethods(clazz, methods, isExcluded, patterns, includedFilters, excludedFilters);
            }
        }
        if (test != null && !test.isEmpty()) {
            TestListResolver.updatedFilters(isExcluded, test, patterns, includedFilters, excludedFilters);
        }
    }

    private static boolean haveMethodPatterns(Set<ResolvedTest> patterns) {
        for (ResolvedTest pattern : patterns) {
            if (!pattern.hasTestMethodPattern()) continue;
            return true;
        }
        return false;
    }
}

