/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.maven.shadefire.surefire.api.testset.TestSetFailedException;
import org.apache.maven.shadefire.surefire.common.junit3.JUnit3Reflector;
import org.apache.maven.shadefire.surefire.junit.JUnit3Reporter;
import org.apache.maven.shadefire.surefire.junit.SurefireTestSetExecutor;
import org.apache.maven.shadefire.surefire.junit.TestListenerInvocationHandler;

public final class JUnitTestSetExecutor
implements SurefireTestSetExecutor {
    private final JUnit3Reflector reflector;
    private final JUnit3Reporter reporter;

    public JUnitTestSetExecutor(JUnit3Reflector reflector, JUnit3Reporter reporter) {
        this.reflector = reflector;
        this.reporter = reporter;
    }

    @Override
    public void execute(Class<?> testClass, ClassLoader loader) throws TestSetFailedException {
        try {
            Object testObject = this.reflector.constructTestObject(testClass);
            Method runMethod = this.reflector.getTestInterface().isAssignableFrom(testObject.getClass()) ? this.reflector.getTestInterfaceRunMethod() : this.reflector.getRunMethod(testClass);
            Object instanceOfTestResult = this.reflector.getTestResultClass().newInstance();
            TestListenerInvocationHandler invocationHandler = new TestListenerInvocationHandler(this.reporter);
            Object testListener = Proxy.newProxyInstance(loader, this.reflector.getInterfacesImplementedByDynamicProxy(), (InvocationHandler)invocationHandler);
            Object[] addTestListenerParams = new Object[]{testListener};
            this.reflector.getAddListenerMethod().invoke(instanceOfTestResult, addTestListenerParams);
            Object[] runParams = new Object[]{instanceOfTestResult};
            runMethod.invoke(testObject, runParams);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(testClass.getName(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Class is not a JUnit TestCase", e);
        }
        catch (ReflectiveOperationException e) {
            throw new TestSetFailedException(testClass.getName(), e);
        }
    }
}

