/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.report;

import org.apache.maven.shadefire.surefire.api.report.OutputReportEntry;
import org.apache.maven.shadefire.surefire.api.report.RunMode;

public final class TestOutputReportEntry
implements OutputReportEntry {
    private final String log;
    private final boolean isStdOut;
    private final boolean newLine;
    private final RunMode runMode;
    private final Long testRunId;

    public TestOutputReportEntry(String log, boolean isStdOut, boolean newLine, RunMode runMode, Long testRunId) {
        this.log = log;
        this.isStdOut = isStdOut;
        this.newLine = newLine;
        this.runMode = runMode;
        this.testRunId = testRunId;
    }

    private TestOutputReportEntry(String log, boolean isStdOut, boolean newLine) {
        this(log, isStdOut, newLine, null, null);
    }

    public TestOutputReportEntry(OutputReportEntry reportEntry, RunMode runMode, Long testRunId) {
        this.log = reportEntry.getLog();
        this.isStdOut = reportEntry.isStdOut();
        this.newLine = reportEntry.isNewLine();
        this.runMode = runMode;
        this.testRunId = testRunId;
    }

    @Override
    public String getLog() {
        return this.log;
    }

    @Override
    public boolean isStdOut() {
        return this.isStdOut;
    }

    @Override
    public boolean isNewLine() {
        return this.newLine;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public Long getTestRunId() {
        return this.testRunId;
    }

    public static OutputReportEntry stdOut(String log) {
        return new TestOutputReportEntry(log, true, false);
    }

    public static TestOutputReportEntry stdOutln(String log) {
        return new TestOutputReportEntry(log, true, true);
    }

    public static TestOutputReportEntry stdErr(String log) {
        return new TestOutputReportEntry(log, false, false);
    }

    public static TestOutputReportEntry stdErrln(String log) {
        return new TestOutputReportEntry(log, false, true);
    }
}

