/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.shadefire.surefire.api.filter.SpecificTestClassFilter;
import org.apache.maven.shadefire.surefire.api.util.DirectoryScanner;
import org.apache.maven.shadefire.surefire.api.util.ScannerFilter;
import org.apache.maven.shadefire.surefire.api.util.TestsToRun;

@Deprecated
public class DefaultDirectoryScanner
implements DirectoryScanner {
    private static final String FS = System.getProperty("file.separator");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String JAVA_SOURCE_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private final File basedir;
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> specificTests;

    public DefaultDirectoryScanner(File basedir, List<String> includes, List<String> excludes, List<String> specificTests) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
    }

    @Override
    public TestsToRun locateTestClasses(ClassLoader classLoader, ScannerFilter scannerFilter) {
        String[] testClassNames = this.collectTests();
        LinkedHashSet result = new LinkedHashSet();
        String[] specific = this.specificTests == null ? new String[]{} : DefaultDirectoryScanner.processIncludesExcludes(this.specificTests);
        SpecificTestClassFilter specificTestFilter = new SpecificTestClassFilter(specific);
        for (String className : testClassNames) {
            Class<?> testClass = DefaultDirectoryScanner.loadClass(classLoader, className);
            if (!specificTestFilter.accept(testClass) || scannerFilter != null && !scannerFilter.accept(testClass)) continue;
            result.add(testClass);
        }
        return new TestsToRun(result);
    }

    private static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to create test class '" + className + "'", e);
        }
    }

    String[] collectTests() {
        String[] tests = EMPTY_STRING_ARRAY;
        if (this.basedir.exists()) {
            org.apache.maven.shadefire.surefire.shared.utils.io.DirectoryScanner scanner = new org.apache.maven.shadefire.surefire.shared.utils.io.DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(DefaultDirectoryScanner.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(DefaultDirectoryScanner.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            tests = scanner.getIncludedFiles();
            for (int i = 0; i < tests.length; ++i) {
                String test = tests[i];
                test = test.substring(0, test.indexOf("."));
                tests[i] = test.replace(FS.charAt(0), '.');
            }
        }
        return tests;
    }

    private static String[] processIncludesExcludes(List<String> list) {
        ArrayList newList = new ArrayList();
        for (String include : list) {
            String[] includes = include.split(",");
            Collections.addAll(newList, includes);
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            String inc = (String)newList.get(i);
            if (inc.endsWith(JAVA_SOURCE_FILE_EXTENSION)) {
                inc = inc.substring(0, inc.lastIndexOf(JAVA_SOURCE_FILE_EXTENSION)) + JAVA_CLASS_FILE_EXTENSION;
            }
            incs[i] = inc;
        }
        return incs;
    }
}

