/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.booter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.shadefire.booter.Classpath;
import org.apache.maven.surefire.shadefire.booter.KeyValueSource;
import org.apache.maven.surefire.shadefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.shadefire.util.internal.StringUtils;

public class PropertiesWrapper
implements KeyValueSource {
    private final Properties properties;
    static /* synthetic */ Class class$java$io$File;

    public PropertiesWrapper(Properties properties) {
        if (properties == null) {
            throw new IllegalStateException("Properties cannot be null");
        }
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setAsSystemProperties() {
        Iterator<Object> i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.setProperty(key, this.properties.getProperty(key));
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBooleanProperty(String propertyName) {
        Boolean aBoolean = Boolean.valueOf(this.properties.getProperty(propertyName));
        return aBoolean;
    }

    public Boolean getBooleanObjectProperty(String propertyName) {
        return Boolean.valueOf(this.properties.getProperty(propertyName));
    }

    public File getFileProperty(String key) {
        String property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        TypeEncodedValue typeEncodedValue = new TypeEncodedValue((class$java$io$File == null ? (class$java$io$File = PropertiesWrapper.class$("java.io.File")) : class$java$io$File).getName(), property);
        return (File)typeEncodedValue.getDecodedValue();
    }

    public List getStringList(String propertyPrefix) {
        String value;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((value = this.getProperty(propertyPrefix + i)) != null) {
            result.add(value);
            ++i;
        }
        return result;
    }

    public TypeEncodedValue getTypeEncodedValue(String key) {
        String typeEncoded = this.getProperty(key);
        if (typeEncoded == null) {
            return null;
        }
        int typeSep = typeEncoded.indexOf("|");
        String type = typeEncoded.substring(0, typeSep);
        String value = typeEncoded.substring(typeSep + 1);
        return new TypeEncodedValue(type, value);
    }

    public void setProperty(String key, File file) {
        if (file != null) {
            this.setProperty(key, file.toString());
        }
    }

    public void setProperty(String key, Boolean aBoolean) {
        if (aBoolean != null) {
            this.setProperty(key, aBoolean.toString());
        }
    }

    Classpath getClasspath(String prefix) {
        List elements = this.getStringList(prefix);
        return new Classpath(elements);
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List classpathElements = classpath.getClassPath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = (String)classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        }
    }

    public void addList(List items, String propertyPrefix) {
        if (items == null || items.size() == 0) {
            return;
        }
        int i = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item == null) {
                throw new NullPointerException(propertyPrefix + i + " has null value");
            }
            String[] stringArray = StringUtils.split(item.toString(), ",");
            for (int j = 0; j < stringArray.length; ++j) {
                this.properties.setProperty(propertyPrefix + i, stringArray[j]);
                ++i;
            }
        }
    }

    public void copyTo(Map target) {
        Iterator<Object> iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            target.put(key, this.properties.get(key));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

