/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.surefire.shadefire.util.NestedRuntimeException;
import org.apache.maven.surefire.shadefire.util.SurefireReflectionException;

public class ReflectionUtils {
    private static final Class[] NO_ARGS = new Class[0];
    private static final Object[] NO_ARGS_VALUES = new Object[0];

    public static Method getMethod(Object instance, String methodName, Class[] parameters) {
        return ReflectionUtils.getMethod(instance.getClass(), methodName, parameters);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            throw new NestedRuntimeException("When finding method " + methodName, e);
        }
    }

    public static Method tryGetMethod(Class clazz, String methodName, Class[] parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object invokeGetter(Object instance, String methodName) {
        Method method = ReflectionUtils.getMethod(instance, methodName, NO_ARGS);
        return ReflectionUtils.invokeMethodWithArray(instance, method, NO_ARGS_VALUES);
    }

    public static Constructor getConstructor(Class clazz, Class[] arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object newInstance(Constructor constructor, Object[] params) {
        try {
            return constructor.newInstance(params);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiate(ClassLoader classLoader, String classname) {
        try {
            Class clazz = ReflectionUtils.loadClass(classLoader, classname);
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateOneArg(ClassLoader classLoader, String className, Class param1Class, Object param1) {
        try {
            Class aClass = ReflectionUtils.loadClass(classLoader, className);
            Constructor constructor = ReflectionUtils.getConstructor(aClass, new Class[]{param1Class});
            return constructor.newInstance(param1);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateTwoArgs(ClassLoader classLoader, String className, Class param1Class, Object param1, Class param2Class, Object param2) {
        try {
            Class aClass = ReflectionUtils.loadClass(classLoader, className);
            Constructor constructor = ReflectionUtils.getConstructor(aClass, new Class[]{param1Class, param2Class});
            return constructor.newInstance(param1, param2);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static void invokeSetter(Object o, String name, Class value1clazz, Object value) {
        Method setter = ReflectionUtils.getMethod(o, name, new Class[]{value1clazz});
        ReflectionUtils.invokeSetter(o, setter, value);
    }

    public static Object invokeSetter(Object target, Method method, Object value) {
        return ReflectionUtils.invokeMethodWithArray(target, method, new Object[]{value});
    }

    public static Object invokeMethodWithArray(Object target, Method method, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public static Object instantiateObject(String className, Class[] types, Object[] params, ClassLoader classLoader) {
        Class clazz = ReflectionUtils.loadClass(classLoader, className);
        Constructor constructor = ReflectionUtils.getConstructor(clazz, types);
        return ReflectionUtils.newInstance(constructor, params);
    }

    public static Class tryLoadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (NoClassDefFoundError ignore) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Class loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            throw new SurefireReflectionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException(e);
        }
    }
}

