/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import org.apache.maven.plugin.surefire.runorder.RunEntryStatistics;

public class Priority {
    private final String className;
    int priority;
    int totalRuntime = 0;
    int minSuccessRate = Integer.MAX_VALUE;

    public Priority(String className) {
        this.className = className;
    }

    public static Priority lowest(String className) {
        Priority priority1 = new Priority(className);
        priority1.setPriority(Integer.MAX_VALUE);
        priority1.minSuccessRate = 0;
        return priority1;
    }

    public void addItem(RunEntryStatistics itemStat) {
        this.totalRuntime += itemStat.getRunTime();
        this.minSuccessRate = Math.min(this.minSuccessRate, itemStat.getSuccessfulBuilds());
    }

    public int getTotalRuntime() {
        return this.totalRuntime;
    }

    public int getMinSuccessRate() {
        return this.minSuccessRate;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

