/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shadefire.common.junit3;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.maven.surefire.shadefire.NonAbstractClassFilter;
import org.apache.maven.surefire.shadefire.util.ReflectionUtils;
import org.apache.maven.surefire.shadefire.util.ScannerFilter;

public class JUnit3TestChecker
implements ScannerFilter {
    private final Class junitClass;
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final NonAbstractClassFilter nonAbstractClassFilter = new NonAbstractClassFilter();
    static /* synthetic */ Class class$junit$framework$Test;

    public JUnit3TestChecker(ClassLoader testClassLoader) {
        this.junitClass = ReflectionUtils.tryLoadClass(testClassLoader, "junit.framework.Test");
    }

    public boolean accept(Class testClass) {
        return this.nonAbstractClassFilter.accept(testClass) && this.isValidJUnit3Test(testClass);
    }

    private boolean isValidJUnit3Test(Class testClass) {
        return this.junitClass != null && (this.junitClass.isAssignableFrom(testClass) || this.isSuiteOnly(testClass));
    }

    public boolean isSuiteOnly(Class testClass) {
        int modifiers;
        Method suite = ReflectionUtils.tryGetMethod(testClass, "suite", EMPTY_CLASS_ARRAY);
        if (suite != null && Modifier.isPublic(modifiers = suite.getModifiers()) && Modifier.isStatic(modifiers)) {
            return (class$junit$framework$Test == null ? (class$junit$framework$Test = JUnit3TestChecker.class$("junit.framework.Test")) : class$junit$framework$Test).isAssignableFrom(suite.getReturnType());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

