/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.org.codehaus.plexus.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.maven.shadefire.org.codehaus.plexus.util.AbstractScanner;

public class DirectoryScanner
extends AbstractScanner {
    protected File basedir;
    protected Vector<String> filesIncluded;
    protected Vector<String> filesNotIncluded;
    protected Vector<String> filesExcluded;
    protected Vector<String> dirsIncluded;
    protected Vector<String> dirsNotIncluded;
    protected Vector<String> dirsExcluded;
    protected Vector<String> filesDeselected;
    protected Vector<String> dirsDeselected;
    protected boolean haveSlowResults = false;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        this.setupDefaultFilters();
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] excl = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(excl);
        Object[] notIncl = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(notIncl);
        for (Object anExcl : excl) {
            if (this.couldHoldIncluded((String)anExcl)) continue;
            this.scandir(new File(this.basedir, (String)anExcl), (String)anExcl + File.separator, false);
        }
        for (Object aNotIncl : notIncl) {
            if (this.couldHoldIncluded((String)aNotIncl)) continue;
            this.scandir(new File(this.basedir, (String)aNotIncl), (String)aNotIncl + File.separator, false);
        }
        this.haveSlowResults = true;
    }

    /*
     * WARNING - void declaration
     */
    protected void scandir(File dir, String vpath, boolean fast) {
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            newfiles = new String[]{};
        }
        if (!this.followSymlinks) {
            void var8_10;
            Vector<String> noLinks = new Vector<String>();
            Object[] arr$ = newfiles;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_10 < len$) {
                String string = arr$[var8_10];
                try {
                    if (this.isSymbolicLink(dir, string)) {
                        String name = vpath + string;
                        File file = new File(dir, string);
                        if (file.isDirectory()) {
                            this.dirsExcluded.addElement(name);
                        } else {
                            this.filesExcluded.addElement(name);
                        }
                    } else {
                        noLinks.addElement(string);
                    }
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get cannonical path!";
                    System.err.println(msg);
                    noLinks.addElement(string);
                }
                ++var8_10;
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        for (String string : newfiles) {
            String string2 = vpath + string;
            File file = new File(dir, string);
            if (file.isDirectory()) {
                if (this.isIncluded(string2)) {
                    if (!this.isExcluded(string2)) {
                        if (this.isSelected(string2, file)) {
                            this.dirsIncluded.addElement(string2);
                            if (fast) {
                                this.scandir(file, string2 + File.separator, fast);
                            }
                        } else {
                            this.everythingIncluded = false;
                            this.dirsDeselected.addElement(string2);
                            if (fast && this.couldHoldIncluded(string2)) {
                                this.scandir(file, string2 + File.separator, fast);
                            }
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.dirsExcluded.addElement(string2);
                        if (fast && this.couldHoldIncluded(string2)) {
                            this.scandir(file, string2 + File.separator, fast);
                        }
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (fast && this.couldHoldIncluded(string2)) {
                        this.scandir(file, string2 + File.separator, fast);
                    }
                }
                if (fast) continue;
                this.scandir(file, string2 + File.separator, fast);
                continue;
            }
            if (!file.isFile()) continue;
            if (this.isIncluded(string2)) {
                if (!this.isExcluded(string2)) {
                    if (this.isSelected(string2, file)) {
                        this.filesIncluded.addElement(string2);
                        continue;
                    }
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(string2);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesExcluded.addElement(string2);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(string2);
        }
    }

    protected boolean isSelected(String name, File file) {
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        return files;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    public String[] getIncludedDirectories() {
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        return directories;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File resolvedParent = new File(parent.getCanonicalPath());
        File toTest = new File(resolvedParent, name);
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }
}

