/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentReporterManager;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.notification.RunListener;

public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final List<RunListener> customRunListeners;
    private final ProviderParameters providerParameters;
    private TestsToRun testsToRun;
    private final ReporterConfiguration reporterConfiguration;

    public JUnitCoreProvider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.reporterConfiguration = booterParameters.getReporterConfiguration();
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.jUnitCoreParameters = new JUnitCoreParameters(booterParameters.getProviderProperties());
        this.scannerFilter = new JUnit4TestChecker(this.testClassLoader);
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        String message = "Concurrency config is " + this.jUnitCoreParameters.toString();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        reporterFactory.createReporter().writeMessage(message);
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentReporterManager listener = ConcurrentReporterManager.createInstance(testSetMap, reporterFactory, this.reporterConfiguration, this.jUnitCoreParameters.isParallelClasses(), this.jUnitCoreParameters.isParallelBoth());
        JUnitCoreRunListener jUnit4RunListener = new JUnitCoreRunListener(listener, testSetMap);
        this.customRunListeners.add(0, jUnit4RunListener);
        JUnitCoreWrapper.execute(this.testsToRun, this.jUnitCoreParameters, this.customRunListeners);
        return reporterFactory.close();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, this.scannerFilter);
    }
}

