/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.util.internal.ByteBuffer;

public class LogicalStream {
    private final List<Entry> output = new ArrayList<Entry>();

    public synchronized void write(boolean stdout, byte[] b, int off, int len) {
        Entry entry = new Entry(stdout, b, off, len);
        if (!entry.isBlankLine()) {
            this.output.add(entry);
        }
    }

    public void writeDetails(Reporter reporter) {
        for (Entry entry : this.output) {
            entry.writeDetails(reporter);
        }
    }

    public void writeDetails(ConsoleOutputReceiver outputReceiver) {
        for (Entry entry : this.output) {
            entry.writeDetails(outputReceiver);
        }
    }

    public String getOutput(boolean stdOut) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.output) {
            if (stdOut != entry.isStdout()) continue;
            entry.writeTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    class Entry {
        final boolean stdout;
        final byte[] b;
        final int off;
        final int len;

        Entry(boolean stdout, byte[] b, int off, int len) {
            this.stdout = stdout;
            this.b = ByteBuffer.copy((byte[])b, (int)off, (int)len);
            this.off = 0;
            this.len = len;
        }

        public boolean isStdout() {
            return this.stdout;
        }

        public void writeTo(StringBuilder stringBuilder) {
            String str = new String(this.b, this.off, this.len);
            stringBuilder.append(str);
        }

        public void writeDetails(Reporter reporter) {
            String str = new String(this.b, this.off, this.len);
            reporter.writeDetailMessage(str);
        }

        public void writeDetails(ConsoleOutputReceiver outputReceiver) {
            outputReceiver.writeTestOutput(this.b, this.off, this.len, this.stdout);
        }

        public String toString() {
            return new String(this.b, this.off, this.len);
        }

        public boolean isBlankLine() {
            return "\n".equals(this.toString());
        }
    }
}

