/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockReporter
implements RunListener {
    private final List<String> events = new ArrayList<String>();
    public static final String RUN_STARTED = "RUN_STARTED";
    public static final String RUN_COMPLETED = "RUN_COMPLETED";
    public static final String SET_STARTED = "SET_STARTED";
    public static final String SET_COMPLETED = "SET_COMPLETED";
    public static final String TEST_STARTED = "TEST_STARTED";
    public static final String TEST_COMPLETED = "TEST_COMPLETED";
    public static final String TEST_FAILED = "TEST_FAILED";
    public static final String TEST_ERROR = "TEST_ERROR";
    public static final String TEST_SKIPPED = "TEST_SKIPPED";
    private final AtomicInteger testSucceeded = new AtomicInteger();
    private final AtomicInteger testIgnored = new AtomicInteger();
    private final AtomicInteger testFailed = new AtomicInteger();
    private final AtomicInteger testError = new AtomicInteger();

    public MockReporter() {
    }

    public MockReporter(ReporterConfiguration reporterConfiguration) {
    }

    public void runStarting() {
        this.events.add(RUN_STARTED);
    }

    public void runCompleted() {
        this.events.add(RUN_COMPLETED);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.events.add(SET_STARTED);
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        this.events.add(SET_COMPLETED);
    }

    public void testStarting(ReportEntry report) {
        this.events.add(TEST_STARTED);
    }

    public void testSucceeded(ReportEntry report) {
        this.events.add(TEST_COMPLETED);
        this.testSucceeded.incrementAndGet();
    }

    public void testSkipped(ReportEntry report) {
        this.events.add(TEST_SKIPPED);
        this.testIgnored.incrementAndGet();
    }

    public void writeFooter(String footer) {
    }

    public void writeDetailMessage(String message) {
    }

    public List<String> getEvents() {
        return this.events;
    }

    public int getTestSucceeded() {
        return this.testSucceeded.get();
    }

    public int getTestIgnored() {
        return this.testIgnored.get();
    }

    public int getTestFailed() {
        return this.testFailed.get();
    }

    public void writeConsoleMessage(String message) {
    }

    public void testError(ReportEntry report) {
    }

    public void testFailed(ReportEntry report) {
    }

    public void testAssumptionFailure(ReportEntry report) {
    }
}

