/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableParallelComputer
extends Computer {
    private final boolean fClasses;
    private final boolean fMethods;
    private final boolean fixedPool;
    private final ExecutorService fService;
    private final List<AsynchronousRunner> nonBlockers = Collections.synchronizedList(new ArrayList());

    public ConfigurableParallelComputer() {
        this(true, true, Executors.newCachedThreadPool(), false);
    }

    public ConfigurableParallelComputer(boolean fClasses, boolean fMethods) {
        this(fClasses, fMethods, Executors.newCachedThreadPool(), false);
    }

    public ConfigurableParallelComputer(boolean fClasses, boolean fMethods, Integer numberOfThreads, boolean perCore) {
        this(fClasses, fMethods, Executors.newFixedThreadPool(numberOfThreads * (perCore ? Runtime.getRuntime().availableProcessors() : 1)), true);
    }

    private ConfigurableParallelComputer(boolean fClasses, boolean fMethods, ExecutorService executorService, boolean fixedPool) {
        this.fClasses = fClasses;
        this.fMethods = fMethods;
        this.fService = executorService;
        this.fixedPool = fixedPool;
    }

    public void close() throws ExecutionException {
        for (AsynchronousRunner nonBlocker : this.nonBlockers) {
            nonBlocker.waitForCompletion();
        }
        this.fService.shutdown();
        try {
            this.fService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Runner parallelize(Runner runner, RunnerScheduler runnerInterceptor) {
        if (runner instanceof ParentRunner) {
            ((ParentRunner)runner).setScheduler(runnerInterceptor);
        }
        return runner;
    }

    private RunnerScheduler getMethodInterceptor() {
        if (this.fClasses && this.fMethods) {
            AsynchronousRunner blockingAsynchronousRunner = new AsynchronousRunner(this.fService);
            this.nonBlockers.add(blockingAsynchronousRunner);
            return blockingAsynchronousRunner;
        }
        return this.fMethods ? new AsynchronousRunner(this.fService) : new SynchronousRunner();
    }

    private RunnerScheduler getClassInterceptor() {
        if (this.fClasses) {
            return this.fMethods ? new SynchronousRunner() : new AsynchronousRunner(this.fService);
        }
        return new SynchronousRunner();
    }

    public Runner getSuite(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
        Runner suite = super.getSuite(builder, (Class[])classes);
        return this.fClasses ? this.parallelize(suite, this.getClassInterceptor()) : suite;
    }

    protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
        Runner runner = super.getRunner(builder, testClass);
        return this.fMethods ? this.parallelize(runner, this.getMethodInterceptor()) : runner;
    }

    public String toString() {
        return "ConfigurableParallelComputer{classes=" + this.fClasses + ", methods=" + this.fMethods + ", fixedPool=" + this.fixedPool + '}';
    }

    public class AsynchronousRunner
    implements RunnerScheduler {
        private final List<Future<Object>> futures = Collections.synchronizedList(new ArrayList());
        private final ExecutorService fService;

        public AsynchronousRunner(ExecutorService fService) {
            this.fService = fService;
        }

        public void schedule(final Runnable childStatement) {
            Callable<Object> objectCallable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    childStatement.run();
                    return null;
                }
            };
            this.futures.add(this.fService.submit(objectCallable));
        }

        public void finished() {
            try {
                this.waitForCompletion();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        public void waitForCompletion() throws ExecutionException {
            for (Future<Object> each : this.futures) {
                try {
                    each.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public class SynchronousRunner
    implements RunnerScheduler {
        public void schedule(Runnable childStatement) {
            childStatement.run();
        }

        public void finished() {
        }
    }
}

