/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.junitcore.ClassesParallelRunListener;
import org.apache.maven.surefire.junitcore.ConcurrentPrintStream;
import org.apache.maven.surefire.junitcore.MethodsParallelRunListener;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public abstract class ConcurrentReportingRunListener
extends RunListener {
    protected Map<Class, TestSet> classMethodCounts = new ConcurrentHashMap<Class, TestSet>();
    private final ReporterConfiguration reporterConfiguration;
    private final ThreadLocal<Reporter> reporterManagerThreadLocal = new ThreadLocal();
    protected final boolean reportImmediately;
    private final ConcurrentPrintStream out = new ConcurrentPrintStream(true);
    private final ConcurrentPrintStream err = new ConcurrentPrintStream(false);
    private ReporterFactory reporterFactory;

    public ConcurrentReportingRunListener(ReporterFactory reporterFactory, boolean reportImmediately, ReporterConfiguration reporterConfiguration) throws TestSetFailedException {
        this.reportImmediately = reportImmediately;
        this.reporterFactory = reporterFactory;
        this.reporterConfiguration = reporterConfiguration;
        this.reporterFactory.createReporter();
        System.setOut(this.out);
        System.setErr(this.err);
    }

    protected Reporter getReporterManager() throws TestSetFailedException {
        Reporter reporterManager = this.reporterManagerThreadLocal.get();
        if (reporterManager == null) {
            reporterManager = this.reporterFactory.createReporter();
            this.reporterManagerThreadLocal.set(reporterManager);
        }
        return reporterManager;
    }

    public static ConcurrentReportingRunListener createInstance(ReporterFactory reporterManagerFactory, ReporterConfiguration reporterConfiguration, boolean parallelClasses, boolean parallelBoth) throws TestSetFailedException {
        if (parallelClasses) {
            return new ClassesParallelRunListener(reporterManagerFactory, reporterConfiguration);
        }
        return new MethodsParallelRunListener(reporterManagerFactory, reporterConfiguration, !parallelBoth);
    }

    public void testRunStarted(Description description) throws Exception {
        TestMethod.fillTestCountMap(description, this.classMethodCounts);
    }

    public void testRunFinished(Result result) throws Exception {
        for (TestSet testSet : this.classMethodCounts.values()) {
            testSet.replay(this.getReporterManager());
        }
        this.out.writeTo(this.reporterConfiguration.getOriginalSystemOut());
        this.err.writeTo(this.reporterConfiguration.getOriginalSystemErr());
    }

    protected TestMethod getTestMethod() {
        return TestMethod.getThreadTestMethod();
    }

    protected void detachTestMethodFromThread() {
        TestMethod.detachFromCurrentThread();
    }

    protected TestSet getTestSet(Description description) {
        return this.classMethodCounts.get(description.getTestClass());
    }

    public void testFailure(Failure failure) throws Exception {
        this.getOrCreateTestMethod(failure.getDescription()).testFailure(failure);
    }

    private TestMethod getOrCreateTestMethod(Description description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        return testSet.createTestMethod(description);
    }

    public void testAssumptionFailure(Failure failure) {
        TestMethod.getThreadTestMethod().testAssumptionFailure(failure);
    }

    public void testIgnored(Description description) throws Exception {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = this.getTestSet(description).createTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.getReporterManager(), this.reportImmediately);
    }

    public void testStarted(Description description) throws Exception {
        TestSet testSet = this.getTestSet(description);
        testSet.createTestMethod(description).attachToThread();
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public abstract void checkIfTestSetCanBeReported(TestSet var1) throws TestSetFailedException;

    public void testFinished(Description description) throws Exception {
        this.getTestMethod().testFinished();
        TestSet.getThreadTestSet().incrementFinishedTests(this.getReporterManager(), this.reportImmediately);
        this.detachTestMethodFromThread();
    }
}

