/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;

public final class LogicalStream {
    private final Queue<Entry> output = new ConcurrentLinkedQueue<Entry>();

    public void write(boolean stdout, byte[] b, int off, int len) {
        if (!LogicalStream.isBlankLine(b, len)) {
            Entry entry = new Entry(stdout, b, off, len);
            this.output.add(entry);
        }
    }

    public void writeDetails(ConsoleOutputReceiver outputReceiver) {
        Entry entry = this.output.poll();
        while (entry != null) {
            entry.writeDetails(outputReceiver);
            entry = this.output.poll();
        }
    }

    private static boolean isBlankLine(byte[] b, int len) {
        return b == null || len == 0;
    }

    private static final class Entry {
        private final boolean stdout;
        private final byte[] b;
        private final int off;
        private final int len;

        private Entry(boolean stdout, byte[] b, int off, int len) {
            this.stdout = stdout;
            this.b = Arrays.copyOfRange(b, off, off + len);
            this.off = 0;
            this.len = len;
        }

        private void writeDetails(ConsoleOutputReceiver outputReceiver) {
            outputReceiver.writeTestOutput(this.b, this.off, this.len, this.stdout);
        }
    }
}

