/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.junitcore.pc.ShutdownResult;
import org.apache.maven.surefire.junitcore.pc.ShutdownStatus;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.junit.runner.Computer;
import org.junit.runner.Description;

public abstract class ParallelComputer
extends Computer {
    private static final ThreadFactory DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory();
    private static final double NANOS_IN_A_SECOND = 1.0E9;
    private final ShutdownStatus shutdownStatus = new ShutdownStatus();
    private final ShutdownStatus forcedShutdownStatus = new ShutdownStatus();
    private final long timeoutNanos;
    private final long timeoutForcedNanos;
    private ScheduledExecutorService shutdownScheduler;

    public ParallelComputer(double timeoutInSeconds, double timeoutForcedInSeconds) {
        this.timeoutNanos = ParallelComputer.secondsToNanos(timeoutInSeconds);
        this.timeoutForcedNanos = ParallelComputer.secondsToNanos(timeoutForcedInSeconds);
    }

    protected abstract ShutdownResult describeStopped(boolean var1);

    abstract boolean shutdownThreadPoolsAwaitingKilled();

    protected final void beforeRunQuietly() {
        this.shutdownStatus.setDescriptionsBeforeShutdown(this.hasTimeout() ? this.scheduleShutdown() : null);
        this.forcedShutdownStatus.setDescriptionsBeforeShutdown(this.hasTimeoutForced() ? this.scheduleForcedShutdown() : null);
    }

    protected final boolean afterRunQuietly() {
        this.shutdownStatus.tryFinish();
        this.forcedShutdownStatus.tryFinish();
        boolean notInterrupted = true;
        if (this.shutdownScheduler != null) {
            this.shutdownScheduler.shutdownNow();
            Thread.interrupted();
            try {
                this.shutdownScheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                notInterrupted = false;
            }
        }
        return notInterrupted &= this.shutdownThreadPoolsAwaitingKilled();
    }

    public String describeElapsedTimeout() throws TestSetFailedException {
        StringBuilder msg = new StringBuilder();
        boolean isShutdownTimeout = this.shutdownStatus.isTimeoutElapsed();
        boolean isForcedShutdownTimeout = this.forcedShutdownStatus.isTimeoutElapsed();
        if (isShutdownTimeout || isForcedShutdownTimeout) {
            msg.append("The test run has finished abruptly after timeout of ");
            msg.append(this.nanosToSeconds(ParallelComputer.minTimeout(this.timeoutNanos, this.timeoutForcedNanos)));
            msg.append(" seconds.\n");
            try {
                TreeSet<String> executedTests = new TreeSet<String>();
                TreeSet<String> incompleteTests = new TreeSet<String>();
                if (isShutdownTimeout) {
                    ParallelComputer.printShutdownHook(executedTests, incompleteTests, this.shutdownStatus.getDescriptionsBeforeShutdown());
                }
                if (isForcedShutdownTimeout) {
                    ParallelComputer.printShutdownHook(executedTests, incompleteTests, this.forcedShutdownStatus.getDescriptionsBeforeShutdown());
                }
                if (!executedTests.isEmpty()) {
                    msg.append("These tests were executed in prior to the shutdown operation:\n");
                    for (String executedTest : executedTests) {
                        msg.append(executedTest).append('\n');
                    }
                }
                if (!incompleteTests.isEmpty()) {
                    msg.append("These tests are incomplete:\n");
                    for (String incompleteTest : incompleteTests) {
                        msg.append(incompleteTest).append('\n');
                    }
                }
            }
            catch (InterruptedException e) {
                throw new TestSetFailedException("Timed termination was interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new TestSetFailedException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return msg.toString();
    }

    private Future<ShutdownResult> scheduleShutdown() {
        return this.getShutdownScheduler().schedule(this.createShutdownTask(), this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    private Future<ShutdownResult> scheduleForcedShutdown() {
        return this.getShutdownScheduler().schedule(this.createForcedShutdownTask(), this.timeoutForcedNanos, TimeUnit.NANOSECONDS);
    }

    private ScheduledExecutorService getShutdownScheduler() {
        if (this.shutdownScheduler == null) {
            this.shutdownScheduler = Executors.newScheduledThreadPool(2, DAEMON_THREAD_FACTORY);
        }
        return this.shutdownScheduler;
    }

    private Callable<ShutdownResult> createShutdownTask() {
        return new Callable<ShutdownResult>(){

            @Override
            public ShutdownResult call() throws Exception {
                boolean stampedStatusWithTimeout = ParallelComputer.this.shutdownStatus.tryTimeout();
                return stampedStatusWithTimeout ? ParallelComputer.this.describeStopped(false) : null;
            }
        };
    }

    private Callable<ShutdownResult> createForcedShutdownTask() {
        return new Callable<ShutdownResult>(){

            @Override
            public ShutdownResult call() throws Exception {
                boolean stampedStatusWithTimeout = ParallelComputer.this.forcedShutdownStatus.tryTimeout();
                return stampedStatusWithTimeout ? ParallelComputer.this.describeStopped(true) : null;
            }
        };
    }

    private double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    private boolean hasTimeout() {
        return this.timeoutNanos > 0L;
    }

    private boolean hasTimeoutForced() {
        return this.timeoutForcedNanos > 0L;
    }

    private static long secondsToNanos(double seconds) {
        double nanos = seconds > 0.0 ? seconds * 1.0E9 : 0.0;
        return Double.isInfinite(nanos) || nanos >= 9.223372036854776E18 ? 0L : (long)nanos;
    }

    private static long minTimeout(long timeout1, long timeout2) {
        if (timeout1 == 0L) {
            return timeout2;
        }
        if (timeout2 == 0L) {
            return timeout1;
        }
        return Math.min(timeout1, timeout2);
    }

    private static void printShutdownHook(Collection<String> executedTests, Collection<String> incompleteTests, Future<ShutdownResult> testsBeforeShutdown) throws ExecutionException, InterruptedException {
        if (testsBeforeShutdown != null) {
            for (Description test : testsBeforeShutdown.get().getTriggeredTests()) {
                if (test == null || test.getDisplayName() == null) continue;
                executedTests.add(test.getDisplayName());
            }
            for (Description test : testsBeforeShutdown.get().getIncompleteTests()) {
                if (test == null || test.getDisplayName() == null) continue;
                incompleteTests.add(test.getDisplayName());
            }
        }
    }
}

