/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Computer;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelComputer
extends Computer {
    private ScheduledExecutorService shutdownScheduler;

    public abstract Collection<Description> shutdown(boolean var1);

    protected final void afterRunQuietly() {
        if (this.shutdownScheduler != null) {
            this.shutdownScheduler.shutdownNow();
        }
    }

    public Future<Collection<Description>> scheduleShutdown(int timeout, TimeUnit unit) {
        return this.getShutdownScheduler().schedule(this.createShutdownTask(false), (long)timeout, unit);
    }

    public Future<Collection<Description>> scheduleForcedShutdown(int timeout, TimeUnit unit) {
        return this.getShutdownScheduler().schedule(this.createShutdownTask(true), (long)timeout, unit);
    }

    private ScheduledExecutorService getShutdownScheduler() {
        if (this.shutdownScheduler == null) {
            this.shutdownScheduler = Executors.newScheduledThreadPool(2);
        }
        return this.shutdownScheduler;
    }

    private Callable<Collection<Description>> createShutdownTask(final boolean isForced) {
        return new Callable<Collection<Description>>(){

            @Override
            public Collection<Description> call() throws Exception {
                return ParallelComputer.this.shutdown(isForced);
            }
        };
    }
}

