/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerBuilder;
import org.apache.maven.surefire.testset.TestSetFailedException;

final class ParallelComputerFactory {
    private static int availableProcessors = Runtime.getRuntime().availableProcessors();

    private ParallelComputerFactory() {
        throw new IllegalStateException("Suppresses calling constructor, ensuring non-instantiability.");
    }

    static void overrideAvailableProcessors(int availableProcessors) {
        ParallelComputerFactory.availableProcessors = availableProcessors;
    }

    static void setDefaultAvailableProcessors() {
        availableProcessors = Runtime.getRuntime().availableProcessors();
    }

    static ParallelComputer createParallelComputer(JUnitCoreParameters params) throws TestSetFailedException {
        Concurrency concurrency = ParallelComputerFactory.resolveConcurrency(params);
        ParallelComputerBuilder builder = new ParallelComputerBuilder();
        if (params.isParallelSuites()) {
            ParallelComputerFactory.resolveSuitesConcurrency(builder, concurrency.suites);
        }
        if (params.isParallelClasses()) {
            ParallelComputerFactory.resolveClassesConcurrency(builder, concurrency.classes);
        }
        if (params.isParallelMethod()) {
            ParallelComputerFactory.resolveMethodsConcurrency(builder, concurrency.methods);
        }
        ParallelComputerFactory.resolveCapacity(builder, concurrency.capacity);
        return builder.buildComputer();
    }

    static Concurrency resolveConcurrency(JUnitCoreParameters params) throws TestSetFailedException {
        if (!params.isAnyParallelitySelected()) {
            throw new TestSetFailedException("Unspecified parameter 'parallel'.");
        }
        if (!(params.isUseUnlimitedThreads().booleanValue() || ParallelComputerFactory.hasThreadCount(params) || ParallelComputerFactory.hasThreadCounts(params))) {
            throw new TestSetFailedException("Unspecified thread-count(s). See the parameters useUnlimitedThreads, threadcount, threadcountsuites, threadcountclasses, threadcountmethods.");
        }
        if (params.isUseUnlimitedThreads().booleanValue()) {
            return ParallelComputerFactory.concurrencyForUnlimitedThreads(params);
        }
        if (ParallelComputerFactory.hasThreadCount(params)) {
            if (ParallelComputerFactory.hasThreadCounts(params)) {
                return ParallelComputerFactory.isLeafUnspecified(params) ? ParallelComputerFactory.concurrencyFromAllThreadCountsButUnspecifiedLeafCount(params) : ParallelComputerFactory.concurrencyFromAllThreadCounts(params);
            }
            return ParallelComputerFactory.estimateConcurrency(params);
        }
        return ParallelComputerFactory.concurrencyFromThreadCounts(params);
    }

    private static void resolveSuitesConcurrency(ParallelComputerBuilder builder, int concurrency) {
        if (concurrency > 0) {
            if (concurrency == Integer.MAX_VALUE) {
                builder.parallelSuites();
            } else {
                builder.parallelSuites(concurrency);
            }
        }
    }

    private static void resolveClassesConcurrency(ParallelComputerBuilder builder, int concurrency) {
        if (concurrency > 0) {
            if (concurrency == Integer.MAX_VALUE) {
                builder.parallelClasses();
            } else {
                builder.parallelClasses(concurrency);
            }
        }
    }

    private static void resolveMethodsConcurrency(ParallelComputerBuilder builder, int concurrency) {
        if (concurrency > 0) {
            if (concurrency == Integer.MAX_VALUE) {
                builder.parallelMethods();
            } else {
                builder.parallelMethods(concurrency);
            }
        }
    }

    private static void resolveCapacity(ParallelComputerBuilder builder, int capacity) {
        if (capacity > 0) {
            builder.useOnePool(capacity);
        }
    }

    private static Concurrency concurrencyForUnlimitedThreads(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? ParallelComputerFactory.threadCountSuites(params) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerFactory.threadCountClasses(params) : 0;
        concurrency.methods = params.isParallelMethod() ? ParallelComputerFactory.threadCountMethods(params) : 0;
        concurrency.capacity = Integer.MAX_VALUE;
        return concurrency;
    }

    private static Concurrency estimateConcurrency(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? params.getThreadCountSuites() : 0;
        concurrency.classes = params.isParallelClasses() ? params.getThreadCountClasses() : 0;
        concurrency.methods = params.isParallelMethod() ? params.getThreadCountMethods() : 0;
        concurrency.capacity = params.getThreadCount();
        double ratio = 1.0 / (double)ParallelComputerFactory.countParallelEntities(params);
        int threads = ParallelComputerFactory.multiplyByCoreCount(params, ratio * (double)concurrency.capacity);
        concurrency.suites = params.isParallelSuites() ? threads : 0;
        concurrency.classes = params.isParallelClasses() ? threads : 0;
        int n = concurrency.methods = params.isParallelMethod() ? threads : 0;
        if (ParallelComputerFactory.countParallelEntities(params) == 1) {
            concurrency.capacity = 0;
        } else {
            concurrency.capacity = ParallelComputerFactory.multiplyByCoreCount(params, concurrency.capacity);
            ParallelComputerFactory.adjustLeaf(params, concurrency);
        }
        return concurrency;
    }

    private static Concurrency concurrencyFromAllThreadCountsButUnspecifiedLeafCount(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? params.getThreadCountSuites() : 0;
        concurrency.classes = params.isParallelClasses() ? params.getThreadCountClasses() : 0;
        concurrency.methods = params.isParallelMethod() ? params.getThreadCountMethods() : 0;
        concurrency.capacity = params.getThreadCount();
        ParallelComputerFactory.setLeafInfinite(params, concurrency);
        concurrency.suites = params.isParallelSuites() ? ParallelComputerFactory.multiplyByCoreCount(params, concurrency.suites) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerFactory.multiplyByCoreCount(params, concurrency.classes) : 0;
        concurrency.methods = params.isParallelMethod() ? ParallelComputerFactory.multiplyByCoreCount(params, concurrency.methods) : 0;
        concurrency.capacity = ParallelComputerFactory.multiplyByCoreCount(params, concurrency.capacity);
        return concurrency;
    }

    private static Concurrency concurrencyFromAllThreadCounts(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? params.getThreadCountSuites() : 0;
        concurrency.classes = params.isParallelClasses() ? params.getThreadCountClasses() : 0;
        concurrency.methods = params.isParallelMethod() ? params.getThreadCountMethods() : 0;
        concurrency.capacity = params.getThreadCount();
        double all = ParallelComputerFactory.sumThreadCounts(concurrency);
        concurrency.suites = params.isParallelSuites() ? ParallelComputerFactory.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.suites / all)) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerFactory.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.classes / all)) : 0;
        concurrency.methods = params.isParallelMethod() ? ParallelComputerFactory.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.methods / all)) : 0;
        concurrency.capacity = ParallelComputerFactory.multiplyByCoreCount(params, concurrency.capacity);
        ParallelComputerFactory.adjustPrecisionInLeaf(params, concurrency);
        return concurrency;
    }

    private static Concurrency concurrencyFromThreadCounts(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? ParallelComputerFactory.threadCountSuites(params) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerFactory.threadCountClasses(params) : 0;
        concurrency.methods = params.isParallelMethod() ? ParallelComputerFactory.threadCountMethods(params) : 0;
        concurrency.capacity = (int)Math.min(ParallelComputerFactory.sumThreadCounts(concurrency), 2.147483647E9);
        return concurrency;
    }

    private static int countParallelEntities(JUnitCoreParameters params) {
        int count = 0;
        if (params.isParallelSuites()) {
            ++count;
        }
        if (params.isParallelClasses()) {
            ++count;
        }
        if (params.isParallelMethod()) {
            ++count;
        }
        return count;
    }

    private static void adjustPrecisionInLeaf(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethod()) {
            concurrency.methods = concurrency.capacity - concurrency.suites - concurrency.classes;
        } else if (params.isParallelClasses()) {
            concurrency.classes = concurrency.capacity - concurrency.suites;
        }
    }

    private static void adjustLeaf(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethod()) {
            concurrency.methods = Integer.MAX_VALUE;
        } else if (params.isParallelClasses()) {
            concurrency.classes = Integer.MAX_VALUE;
        }
    }

    private static void setLeafInfinite(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethod()) {
            concurrency.methods = Integer.MAX_VALUE;
        } else if (params.isParallelClasses()) {
            concurrency.classes = Integer.MAX_VALUE;
        } else if (params.isParallelSuites()) {
            concurrency.suites = Integer.MAX_VALUE;
        }
    }

    private static boolean isLeafUnspecified(JUnitCoreParameters params) {
        int maskOfParallel = params.isParallelSuites() ? 4 : 0;
        maskOfParallel |= params.isParallelClasses() ? 2 : 0;
        int maskOfConcurrency = params.getThreadCountSuites() > 0 ? 4 : 0;
        maskOfConcurrency |= params.getThreadCountClasses() > 0 ? 2 : 0;
        maskOfConcurrency |= params.getThreadCountMethods() > 0 ? 1 : 0;
        int leaf = Integer.lowestOneBit(maskOfParallel |= params.isParallelMethod() ? 1 : 0);
        return (maskOfConcurrency &= maskOfParallel) == maskOfParallel - leaf;
    }

    private static double sumThreadCounts(Concurrency concurrency) {
        double sum = concurrency.suites;
        sum += (double)concurrency.classes;
        return sum += (double)concurrency.methods;
    }

    private static boolean hasThreadCounts(JUnitCoreParameters jUnitCoreParameters) {
        return jUnitCoreParameters.getThreadCountSuites() > 0 || jUnitCoreParameters.getThreadCountClasses() > 0 || jUnitCoreParameters.getThreadCountMethods() > 0;
    }

    private static boolean hasThreadCount(JUnitCoreParameters jUnitCoreParameters) {
        return jUnitCoreParameters.getThreadCount() > 0;
    }

    private static int threadCountMethods(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerFactory.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountMethods());
    }

    private static int threadCountClasses(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerFactory.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountClasses());
    }

    private static int threadCountSuites(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerFactory.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountSuites());
    }

    private static int multiplyByCoreCount(JUnitCoreParameters jUnitCoreParameters, double threadsPerCore) {
        double numberOfThreads = jUnitCoreParameters.isPerCoreThreadCount() != false ? threadsPerCore * (double)availableProcessors : threadsPerCore;
        return numberOfThreads > 0.0 ? (int)Math.min(numberOfThreads, 2.147483647E9) : Integer.MAX_VALUE;
    }

    static class Concurrency {
        int suites;
        int classes;
        int methods;
        int capacity;

        Concurrency() {
        }
    }
}

