/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ConsoleOutputFileReporter
implements Reporter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final File reportsDirectory;
    private final StringBuffer outputBuffer = new StringBuffer();

    public ConsoleOutputFileReporter(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void testSetStarting(ReportEntry reportEntry) {
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        if (!this.reportsDirectory.exists()) {
            this.reportsDirectory.mkdirs();
        }
        try {
            if (this.outputBuffer.length() > 0) {
                File file = new File(this.reportsDirectory, report.getName() + "-output.txt");
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                printWriter.write(this.outputBuffer.toString());
                printWriter.write(LINE_SEPARATOR);
                this.outputBuffer.setLength(0);
                printWriter.close();
            }
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void testStarting(ReportEntry report) {
    }

    public void testSucceeded(ReportEntry report) {
    }

    public void testSkipped(ReportEntry report) {
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
    }

    public void writeMessage(String message) {
    }

    public void writeMessage(byte[] b, int off, int len) {
        String line = new String(b, off, len);
        this.outputBuffer.append(line);
    }

    public void reset() {
    }
}

