/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunReporter;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.util.internal.ByteBuffer;

public class TestSetRunListener
implements RunListener,
RunReporter,
Reporter,
ConsoleOutputReceiver {
    private final RunStatistics globalStats;
    private final MulticastingReporter multicastingReporter;
    private final List testStdOut = Collections.synchronizedList(new ArrayList());
    private final List testStdErr = Collections.synchronizedList(new ArrayList());

    public TestSetRunListener(List reports, RunStatistics globalStats) {
        this.multicastingReporter = new MulticastingReporter(reports);
        this.globalStats = globalStats;
    }

    public void writeMessage(String message) {
        this.multicastingReporter.writeMessage(message);
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        ByteBuffer byteBuffer = new ByteBuffer(buf, off, len);
        if (stdout) {
            this.testStdOut.add(byteBuffer);
        } else {
            this.testStdErr.add(byteBuffer);
        }
        this.multicastingReporter.writeMessage(new String(buf, off, len));
    }

    public void writeDetailMessage(String message) {
        this.multicastingReporter.writeDetailMessage(message);
    }

    public void runStarting() {
        this.multicastingReporter.runStarting();
    }

    public void runCompleted() {
        Iterator iterator;
        this.multicastingReporter.runCompleted();
        this.multicastingReporter.writeFooter("");
        this.multicastingReporter.writeFooter("Results :");
        this.multicastingReporter.writeFooter("");
        if (this.globalStats.hadFailures()) {
            this.multicastingReporter.writeFooter("Failed tests: ");
            iterator = this.globalStats.getFailureSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        if (this.globalStats.hadErrors()) {
            this.writeFooter("Tests in error: ");
            iterator = this.globalStats.getErrorSources().iterator();
            while (iterator.hasNext()) {
                this.multicastingReporter.writeFooter("  " + iterator.next());
            }
            this.multicastingReporter.writeFooter("");
        }
        this.multicastingReporter.writeFooter(this.globalStats.getSummary());
        this.multicastingReporter.writeFooter("");
    }

    public void writeFooter(String footer) {
        this.multicastingReporter.writeFooter(footer);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.multicastingReporter.testSetStarting(report);
    }

    public void testSetCompleted(ReportEntry report) {
        this.multicastingReporter.testSetCompleted(report);
        this.multicastingReporter.reset();
    }

    public void testStarting(ReportEntry report) {
        this.multicastingReporter.testStarting(report);
    }

    public void testSucceeded(ReportEntry report) {
        this.clearCapturedContent();
        this.globalStats.incrementCompletedCount();
        this.multicastingReporter.testSucceeded(report);
    }

    public void testError(ReportEntry reportEntry) {
        this.testError(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
    }

    public void testError(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testError(reportEntry, stdOutLog, stdErrLog);
        this.globalStats.incrementErrorsCount();
        this.globalStats.incrementCompletedCount();
        this.globalStats.addErrorSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapturedContent();
    }

    public void testFailed(ReportEntry reportEntry) {
        this.testFailed(reportEntry, this.getAsString(this.testStdOut), this.getAsString(this.testStdErr));
    }

    public void testFailed(ReportEntry reportEntry, String stdOutLog, String stdErrLog) {
        this.multicastingReporter.testFailed(reportEntry, stdOutLog, stdErrLog);
        this.globalStats.incrementFailureCount();
        this.globalStats.incrementCompletedCount();
        this.globalStats.addFailureSource(reportEntry.getName(), reportEntry.getStackTraceWriter());
        this.clearCapturedContent();
    }

    public void testSkipped(ReportEntry report) {
        this.clearCapturedContent();
        this.globalStats.incrementSkippedCount();
        this.globalStats.incrementCompletedCount();
        this.multicastingReporter.testSkipped(report);
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.testSkipped(report);
    }

    public void reset() {
        this.multicastingReporter.reset();
    }

    public String getAsString(List byteBufferList) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iter = byteBufferList.iterator();
        while (iter.hasNext()) {
            ByteBuffer byteBuffer = (ByteBuffer)iter.next();
            stringBuffer.append(byteBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public void clearCapturedContent() {
        this.testStdErr.clear();
        this.testStdOut.clear();
    }
}

