/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.TestsToRun;

public abstract class AbstractDirectoryTestSuite
implements SurefireTestSuite {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    protected SortedMap testSets;
    private int totalTests;
    private List classesSkippedByValidation = new ArrayList();
    private final DirectoryScanner surefireDirectoryScanner;

    protected AbstractDirectoryTestSuite(DirectoryScanner surefireDirectoryScanner) {
        this.surefireDirectoryScanner = surefireDirectoryScanner;
    }

    protected AbstractDirectoryTestSuite(File basedir, List includes, List excludes) {
        this.surefireDirectoryScanner = new DefaultDirectoryScanner(basedir, includes, excludes, "filesystem");
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new TreeMap();
        TestsToRun testsToRun = this.surefireDirectoryScanner.locateTestClasses(classLoader, new NonAbstractClassFilter());
        Class[] locatedClasses = testsToRun.getLocatedClasses();
        for (int i = 0; i < locatedClasses.length; ++i) {
            Class testClass = locatedClasses[i];
            SurefireTestSet testSet = this.createTestSet(testClass, classLoader);
            if (testSet == null) {
                this.classesSkippedByValidation.add(testClass);
                continue;
            }
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
            ++this.totalTests;
        }
        return Collections.unmodifiableSortedMap(this.testSets);
    }

    protected abstract SurefireTestSet createTestSet(Class var1, ClassLoader var2) throws TestSetFailedException;

    public void execute(ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        Iterator i = this.testSets.values().iterator();
        while (i.hasNext()) {
            SurefireTestSet testSet = (SurefireTestSet)i.next();
            this.executeTestSet(testSet, reporterManagerFactory, classLoader);
        }
    }

    private void executeTestSet(SurefireTestSet testSet, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = reporterManagerFactory.createReporterManager();
        String rawString = bundle.getString("testSetStarting");
        DefaultReportEntry report = new DefaultReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetStarting(report);
        testSet.execute(reporterManager, classLoader);
        rawString = bundle.getString("testSetCompletedNormally");
        report = new DefaultReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetCompleted(report);
        reporterManager.reset();
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        this.executeTestSet(testSet, reporterManagerFactory, classLoader);
    }

    public List getClassesSkippedByValidation() {
        return Collections.unmodifiableList(this.classesSkippedByValidation);
    }

    public int getNumTests() {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling getNumTests");
        }
        return this.totalTests;
    }
}

