/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.suite.AnnotationFilter;
import org.apache.maven.surefire.suite.AnnotationFilterBuilder;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.SurefireDirectoryScanner;

public abstract class AbstractDirectoryTestSuite
implements SurefireTestSuite {
    private static final String ACCEPTED_ANNOTATIONS = "includedAnnotations";
    private static final String REJECTED_ANNOTATIONS = "excludedAnnotations";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    protected Map testSets;
    private int totalTests;
    private final SurefireDirectoryScanner surefireDirectoryScanner;

    protected AbstractDirectoryTestSuite(File basedir, List includes, List excludes) {
        this.surefireDirectoryScanner = new SurefireDirectoryScanner(basedir, includes, excludes);
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new HashMap();
        Class[] locatedClasses = this.surefireDirectoryScanner.locateTestClasses(classLoader);
        Class[] filteredClasses = this.filterClassesByAnnotations(locatedClasses);
        for (int i = 0; i < filteredClasses.length; ++i) {
            Class testClass = filteredClasses[i];
            SurefireTestSet testSet = this.createTestSet(testClass, classLoader);
            if (testSet == null) continue;
            if (this.testSets.containsKey(testSet.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + testSet.getName() + "'");
            }
            this.testSets.put(testSet.getName(), testSet);
            ++this.totalTests;
        }
        return Collections.unmodifiableMap(this.testSets);
    }

    private Class[] filterClassesByAnnotations(Class[] locatedClasses) {
        ArrayList filteredClasses;
        try {
            AnnotationFilterBuilder builder = new AnnotationFilterBuilder();
            AnnotationFilter filter = builder.build(System.getProperty(ACCEPTED_ANNOTATIONS), System.getProperty(REJECTED_ANNOTATIONS));
            filteredClasses = filter.filter(locatedClasses);
        }
        catch (Exception e) {
            System.out.println("MONCHO Error: " + e.getMessage());
            filteredClasses = new ArrayList();
        }
        return this.copyListToArray(filteredClasses);
    }

    private Class[] copyListToArray(List classesToFilter) {
        Class[] filteredClasses = new Class[classesToFilter.size()];
        for (int i = 0; i < classesToFilter.size(); ++i) {
            filteredClasses[i] = (Class)classesToFilter.get(i);
        }
        return filteredClasses;
    }

    protected abstract SurefireTestSet createTestSet(Class var1, ClassLoader var2) throws TestSetFailedException;

    public void execute(ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        Iterator i = this.testSets.values().iterator();
        while (i.hasNext()) {
            SurefireTestSet testSet = (SurefireTestSet)i.next();
            this.executeTestSet(testSet, reporterManagerFactory, classLoader);
        }
    }

    private void executeTestSet(SurefireTestSet testSet, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = reporterManagerFactory.createReporterManager();
        String rawString = bundle.getString("testSetStarting");
        ReportEntry report = new ReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetStarting(report);
        testSet.execute(reporterManager, classLoader);
        rawString = bundle.getString("testSetCompletedNormally");
        report = new ReportEntry(this.getClass().getName(), testSet.getName(), rawString);
        reporterManager.testSetCompleted(report);
        reporterManager.reset();
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        this.executeTestSet(testSet, reporterManagerFactory, classLoader);
    }

    public int getNumTests() {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling getNumTests");
        }
        return this.totalTests;
    }
}

