/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.assertion;

public class ComparisonTool {
    private ComparisonTool() {
    }

    static String trimComparison(String message, String expected, String actual) {
        String expectedValue;
        String actualValue;
        if (expected == null && actual == null) {
            throw new IllegalArgumentException("Cannot pass both expected and actual as null");
        }
        if (expected == null || actual == null) {
            actualValue = actual;
            expectedValue = expected;
        } else {
            int k;
            int i;
            int end = Math.min(expected.length(), actual.length());
            for (i = 0; i < end && expected.charAt(i) == actual.charAt(i); ++i) {
            }
            int j = expected.length() - 1;
            for (k = actual.length() - 1; k >= i && j >= i && expected.charAt(j) == actual.charAt(k); --k, --j) {
            }
            if (j < i && k < i) {
                throw new IllegalArgumentException("expected and actual cannot be the same");
            }
            expectedValue = expected.substring(i, j + 1);
            actualValue = actual.substring(i, k + 1);
            if (i <= end && i > 0) {
                expectedValue = "..." + expectedValue;
                actualValue = "..." + actualValue;
            }
            if (j < expected.length() - 1) {
                expectedValue = expectedValue + "...";
            }
            if (k < actual.length() - 1) {
                actualValue = actualValue + "...";
            }
        }
        return ComparisonTool.formatMismatch(message, expectedValue, actualValue);
    }

    static String formatMismatch(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

