/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.IOUtil;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.apache.maven.surefire.util.PrettyPrintXMLWriter;

public class XMLFilePerTestReporter
implements Reporter {
    private final File reportsDirectory;
    private boolean trimStackTrace;
    private static final String LS = System.getProperty("line.separator");
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private static final int MS_PER_SEC = 1000;
    private Map testsStartTimes = new HashMap();

    public XMLFilePerTestReporter(File reportsDirectory, Boolean trimStackTrace) {
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
    }

    public void writeMessage(String message) {
    }

    public void writeFooter(String footer) {
    }

    public void runStarting(int testCount) {
    }

    public void runCompleted() {
    }

    public void runStopped() {
    }

    public void runAborted(ReportEntry report) {
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
    }

    public void testSetAborted(ReportEntry report) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarting(ReportEntry report) {
        Map map = this.testsStartTimes;
        synchronized (map) {
            this.testsStartTimes.put(this.getReportName(report), new Long(System.currentTimeMillis()));
        }
    }

    public void testSucceeded(ReportEntry report) {
        String name = this.getReportName(report);
        try {
            Xpp3Dom testCaseElement = this.createTestElement(report, this.getElapsed(name));
            this.writeFile(report, testCaseElement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        String name = this.getReportName(report);
        try {
            Xpp3Dom testCaseElement = this.createTestElement(report, this.getElapsed(name));
            this.writeTestProblems(report, testCaseElement, stdOut, stdErr, "error");
            this.writeFile(report, testCaseElement);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        String name = this.getReportName(report);
        try {
            Xpp3Dom testCaseElement = this.createTestElement(report, this.getElapsed(name));
            this.writeTestProblems(report, testCaseElement, stdOut, stdErr, "failure");
            this.writeFile(report, testCaseElement);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSkipped(ReportEntry report) {
        try {
            Xpp3Dom testCaseElement = this.createTestElement(report, 0L);
            this.writeTestProblems(report, testCaseElement, null, null, "skipped");
            this.writeFile(report, testCaseElement);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.testsStartTimes.clear();
    }

    public int getNumErrors() {
        return 0;
    }

    public int getNumFailures() {
        return 0;
    }

    public int getNumTests() {
        return 0;
    }

    public int getNumSkipped() {
        return 0;
    }

    public Collection getErrorSources() {
        return null;
    }

    public Collection getFailureSources() {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFile(ReportEntry report, Xpp3Dom testCaseElement) throws ReporterException {
        File reportFile = new File(this.reportsDirectory, "TEST-" + this.getReportName(report) + ".xml");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        PrintWriter writer = null;
        Xpp3Dom testSuite = this.createTestSuiteElement(report, 0L);
        testSuite.addChild(testCaseElement);
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + LS);
            Xpp3DomWriter.write(new PrettyPrintXMLWriter(writer), testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ReporterException("Unable to use UTF-8 encoding", e);
                catch (FileNotFoundException e2) {
                    throw new ReporterException("Unable to create file: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    private void showProperties(Xpp3Dom testSuite) {
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", value);
            }
        }
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private Xpp3Dom createTestSuiteElement(ReportEntry report, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom("testsuite");
        testCase.setAttribute("name", this.getReportName(report));
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    private Xpp3Dom createTestElement(ReportEntry report, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom("testcase");
        testCase.setAttribute("name", this.getReportName(report));
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        if (report.getSourceName() != null) {
            testCase.setAttribute("classname", report.getSourceName());
        }
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    private String getReportName(ReportEntry report) {
        String name = report.getName();
        if (name.indexOf("(") > -1) {
            String className = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
            String methodName = name.substring(0, name.indexOf("("));
            return className + "-" + methodName;
        }
        return name;
    }

    protected String elapsedTimeAsString(long runTime) {
        return this.numberFormat.format((double)runTime / 1000.0);
    }

    private void writeTestProblems(ReportEntry report, Xpp3Dom testCaseElement, String stdOut, String stdErr, String name) {
        Xpp3Dom element = this.createElement(testCaseElement, name);
        String stackTrace = this.getStackTrace(report);
        Throwable t = null;
        if (report.getStackTraceWriter() != null) {
            t = report.getStackTraceWriter().getThrowable();
        }
        if (t != null) {
            String message = t.getMessage();
            if (message != null) {
                element.setAttribute("message", message);
                element.setAttribute("type", stackTrace.indexOf(":") > -1 ? stackTrace.substring(0, stackTrace.indexOf(":")) : stackTrace);
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        if (stackTrace != null) {
            element.setValue(stackTrace);
        }
        this.addOutputStreamElement(stdOut, "system-out", testCaseElement);
        this.addOutputStreamElement(stdErr, "system-err", testCaseElement);
    }

    protected String getStackTrace(ReportEntry report) {
        StackTraceWriter writer = report.getStackTraceWriter();
        if (writer == null) {
            return null;
        }
        return this.trimStackTrace ? writer.writeTrimmedTraceToString() : writer.writeTraceToString();
    }

    private void addOutputStreamElement(String stdOut, String name, Xpp3Dom testCase) {
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(testCase, name).setValue(stdOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getElapsed(String name) {
        Long start = null;
        Map map = this.testsStartTimes;
        synchronized (map) {
            start = (Long)this.testsStartTimes.get(name);
            this.testsStartTimes.remove(name);
        }
        if (start != null) {
            return System.currentTimeMillis() - start;
        }
        return 0L;
    }
}

