/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import java.util.Map;
import java.util.Set;
import org.apache.maven.surefire.common.junit48.AndFilter;
import org.apache.maven.surefire.common.junit48.FailingMethodFilter;
import org.apache.maven.surefire.common.junit48.GroupMatcherCategoryFilter;
import org.apache.maven.surefire.common.junit48.MethodFilter;
import org.apache.maven.surefire.group.match.GroupMatcher;
import org.apache.maven.surefire.group.parse.GroupMatcherParser;
import org.apache.maven.surefire.group.parse.ParseException;
import org.apache.maven.surefire.testset.TestListResolver;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    private final ClassLoader testClassLoader;

    public FilterFactory(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public Filter createGroupFilter(Map<String, String> providerProperties) {
        String groups = providerProperties.get("groups");
        String excludedGroups = providerProperties.get("excludegroups");
        GroupMatcher included = null;
        if (groups != null && groups.trim().length() > 0) {
            try {
                included = new GroupMatcherParser(groups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + groups + "'. Reason: " + e.getMessage(), e);
            }
        }
        GroupMatcher excluded = null;
        if (excludedGroups != null && excludedGroups.trim().length() > 0) {
            try {
                excluded = new GroupMatcherParser(excludedGroups).parse();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid group expression: '" + excludedGroups + "'. Reason: " + e.getMessage(), e);
            }
        }
        if (included != null && this.testClassLoader != null) {
            included.loadGroupClasses(this.testClassLoader);
        }
        if (excluded != null && this.testClassLoader != null) {
            excluded.loadGroupClasses(this.testClassLoader);
        }
        return new GroupMatcherCategoryFilter(included, excluded);
    }

    public Filter createMethodFilter(String requestedTestMethod) {
        return new MethodFilter(requestedTestMethod);
    }

    public Filter createMethodFilter(TestListResolver resolver) {
        return new MethodFilter(resolver);
    }

    public Filter createFailingMethodFilter(Map<Class<?>, Set<String>> failingClassMethodMap) {
        return new FailingMethodFilter(failingClassMethodMap);
    }

    public Filter and(Filter filter1, Filter filter2) {
        return new AndFilter(filter1, filter2);
    }
}

