/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.surefire.common.junit4.ClassMethod;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JUnit4ProviderUtil {
    private JUnit4ProviderUtil() {
        throw new IllegalStateException("Cannot instantiate.");
    }

    public static Map<Class<?>, Set<String>> generateFailingTests(List<Failure> allFailures, ClassLoader testClassLoader) throws TestSetFailedException {
        HashMap testClassMethods = new HashMap();
        Set<ClassMethod> failingTests = JUnit4ProviderUtil.generateFailingTests(allFailures);
        for (ClassMethod classMethod : failingTests) {
            try {
                Class<?> testClassObj = Class.forName(classMethod.getClazz(), false, testClassLoader);
                HashSet<String> failingMethods = (HashSet<String>)testClassMethods.get(testClassObj);
                if (failingMethods == null) {
                    failingMethods = new HashSet<String>();
                    testClassMethods.put(testClassObj, failingMethods);
                }
                failingMethods.add(classMethod.getMethod());
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException("Unable to create test class '" + classMethod.getClazz() + "'", (Throwable)e);
            }
        }
        return testClassMethods;
    }

    public static Set<ClassMethod> generateFailingTests(List<Failure> allFailures) {
        HashSet<ClassMethod> failingMethods = new HashSet<ClassMethod>();
        for (Failure failure : allFailures) {
            ClassMethod classMethod;
            Description description = failure.getDescription();
            if (!description.isTest() || JUnit4ProviderUtil.isFailureInsideJUnitItself(description) || !(classMethod = JUnit4ProviderUtil.cutTestClassAndMethod(description)).isValid()) continue;
            failingMethods.add(classMethod);
        }
        return failingMethods;
    }

    public static Description createSuiteDescription(Collection<Class<?>> classes) {
        return JUnit4Reflector.createRequest(classes.toArray(new Class[classes.size()])).getRunner().getDescription();
    }

    public static boolean isFailureInsideJUnitItself(Description failure) {
        return Description.TEST_MECHANISM.equals((Object)failure);
    }

    public static ClassMethod cutTestClassAndMethod(Description description) {
        int classBracket;
        String name = description.getDisplayName();
        String clazz = null;
        String method = null;
        if (name != null && (name = name.trim()).endsWith(")") && (classBracket = name.lastIndexOf(40)) != -1) {
            clazz = JUnit4ProviderUtil.tryBlank(name.substring(classBracket + 1, name.length() - 1));
            method = JUnit4ProviderUtil.tryBlank(name.substring(0, classBracket));
        }
        return new ClassMethod(clazz, method);
    }

    private static String tryBlank(String s) {
        return StringUtils.isBlank((String)(s = s.trim())) ? null : s;
    }
}

