/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4RunListener
extends RunListener {
    private static final Pattern PARENS = Pattern.compile("^.+\\(([^\\\\(\\\\)]+)\\)$");
    protected final org.apache.maven.surefire.report.RunListener reporter;
    private final ThreadLocal<Boolean> failureFlag = new InheritableThreadLocal<Boolean>();
    private final JUnit4Reflector jUnit4Reflector = new JUnit4Reflector();

    public JUnit4RunListener(org.apache.maven.surefire.report.RunListener reporter) {
        this.reporter = reporter;
    }

    public void testIgnored(Description description) throws Exception {
        String reason = this.jUnit4Reflector.getAnnotatedIgnoreValue(description);
        SimpleReportEntry report = SimpleReportEntry.ignored((String)this.getClassName(description), (String)description.getDisplayName(), (String)reason);
        this.reporter.testSkipped((ReportEntry)report);
    }

    public void testStarted(Description description) throws Exception {
        this.reporter.testStarting((ReportEntry)this.createReportEntry(description));
        this.failureFlag.remove();
    }

    public void testFailure(Failure failure) throws Exception {
        SimpleReportEntry report = SimpleReportEntry.withException((String)this.getClassName(failure.getDescription()), (String)failure.getTestHeader(), (StackTraceWriter)this.createStackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reporter.testFailed((ReportEntry)report);
        } else {
            this.reporter.testError((ReportEntry)report);
        }
        this.failureFlag.set(Boolean.TRUE);
    }

    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit4StackTraceWriter(failure);
    }

    public void testAssumptionFailure(Failure failure) {
        this.reporter.testAssumptionFailure((ReportEntry)this.createReportEntry(failure.getDescription()));
        this.failureFlag.set(Boolean.TRUE);
    }

    public void testFinished(Description description) throws Exception {
        Boolean failure = this.failureFlag.get();
        if (failure == null) {
            this.reporter.testSucceeded((ReportEntry)this.createReportEntry(description));
        }
    }

    protected SimpleReportEntry createReportEntry(Description description) {
        return new SimpleReportEntry(this.getClassName(description), description.getDisplayName());
    }

    public String getClassName(Description description) {
        return JUnit4RunListener.extractClassName(description);
    }

    public static String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }

    public static void rethrowAnyTestMechanismFailures(Result run) throws TestSetFailedException {
        if (run.getFailureCount() > 0) {
            for (Failure failure : run.getFailures()) {
                if (!JUnit4RunListener.isFailureInsideJUnitItself(failure)) continue;
                Throwable exception = failure.getException();
                throw new TestSetFailedException(exception);
            }
        }
    }

    private static boolean isFailureInsideJUnitItself(Failure failure) {
        return failure.getDescription().getDisplayName().equals("Test mechanism");
    }
}

