/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.shared.model.DataSourceException;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelDataSource;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultModelDataSource
implements ModelDataSource {
    private List<ModelProperty> modelProperties;
    private List<ModelProperty> originalModelProperties;
    private List<DataEvent> dataEvents;
    private Map<String, ModelContainerFactory> modelContainerFactoryMap;

    @Override
    public ModelContainer join(ModelContainer a, ModelContainer b) throws DataSourceException {
        if (a == null || a.getProperties() == null || a.getProperties().size() == 0) {
            throw new IllegalArgumentException("a or a.properties: empty");
        }
        if (b == null || b.getProperties() == null) {
            throw new IllegalArgumentException("b: null or b.properties: empty");
        }
        if (a.equals(b) || b.getProperties().size() == 0) {
            return a;
        }
        int startIndex = this.modelProperties.indexOf(b.getProperties().get(0));
        if (startIndex == -1) {
            startIndex = this.modelProperties.indexOf(a.getProperties().get(0));
        }
        this.delete(a);
        this.delete(b);
        List<ModelProperty> joinedProperties = DefaultModelDataSource.mergeModelContainers(a, b);
        if (this.modelProperties.size() == 0) {
            startIndex = 0;
        }
        joinedProperties = DefaultModelDataSource.sort(joinedProperties, DefaultModelDataSource.findBaseUriFrom(joinedProperties));
        this.modelProperties.addAll(startIndex, joinedProperties);
        ArrayList<ModelProperty> deletedProperties = new ArrayList<ModelProperty>();
        deletedProperties.addAll(a.getProperties());
        deletedProperties.addAll(b.getProperties());
        deletedProperties.removeAll(joinedProperties);
        if (deletedProperties.size() > 0) {
            this.dataEvents.add(new DataEvent(a, b, deletedProperties, "join"));
        }
        return a.createNewInstance(joinedProperties);
    }

    @Override
    public void delete(ModelContainer modelContainer) {
        if (modelContainer == null) {
            throw new IllegalArgumentException("modelContainer: null");
        }
        if (modelContainer.getProperties() == null) {
            throw new IllegalArgumentException("modelContainer.properties: null");
        }
        this.modelProperties.removeAll(modelContainer.getProperties());
        this.dataEvents.add(new DataEvent(modelContainer, null, modelContainer.getProperties(), "delete"));
    }

    @Override
    public List<ModelProperty> getModelProperties() {
        return new ArrayList<ModelProperty>(this.modelProperties);
    }

    @Override
    public List<ModelContainer> queryFor(String uri) throws DataSourceException {
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        if (this.modelProperties.isEmpty()) {
            return Collections.emptyList();
        }
        ModelContainerFactory factory = this.modelContainerFactoryMap.get(uri);
        if (factory == null) {
            throw new DataSourceException("Unable to find factory for uri: URI = " + uri);
        }
        LinkedList<ModelContainer> modelContainers = new LinkedList<ModelContainer>();
        boolean NO_TAG = false;
        boolean START_TAG = true;
        int END_START_TAG = 2;
        int END_TAG = 3;
        int state = 0;
        ArrayList<ModelProperty> tmp = new ArrayList<ModelProperty>();
        Iterator<ModelProperty> i = this.modelProperties.iterator();
        while (i.hasNext()) {
            ModelProperty mp = i.next();
            state = state == 1 && (!i.hasNext() || !mp.getUri().startsWith(uri)) ? 3 : (state == 1 && mp.getUri().equals(uri) ? 2 : (mp.getUri().startsWith(uri) ? 1 : 0));
            switch (state) {
                case 1: {
                    tmp.add(mp);
                    if (i.hasNext()) break;
                    modelContainers.add(factory.create(tmp));
                    break;
                }
                case 2: {
                    modelContainers.add(factory.create(tmp));
                    tmp.clear();
                    tmp.add(mp);
                    state = 1;
                    break;
                }
                case 3: {
                    if (!i.hasNext() && mp.getUri().startsWith(uri)) {
                        tmp.add(mp);
                    }
                    modelContainers.add(factory.create(tmp));
                    tmp.clear();
                    state = 0;
                }
            }
        }
        List<ModelProperty> unknownProperties = this.findUnknownModelPropertiesFrom(modelContainers);
        if (!unknownProperties.isEmpty()) {
            for (ModelProperty mp : unknownProperties) {
                System.out.println("Missing property from ModelContainer: " + mp);
            }
            throw new DataSourceException("Unable to query datasource. ModelContainer contains elements not within datasource");
        }
        return modelContainers;
    }

    @Override
    public void init(List<ModelProperty> modelProperties, Collection<ModelContainerFactory> modelContainerFactories) {
        if (modelProperties == null) {
            throw new IllegalArgumentException("modelProperties: null");
        }
        if (modelContainerFactories == null) {
            throw new IllegalArgumentException("modeContainerFactories: null");
        }
        this.modelProperties = new LinkedList<ModelProperty>(modelProperties);
        this.modelContainerFactoryMap = new HashMap<String, ModelContainerFactory>();
        this.dataEvents = new ArrayList<DataEvent>();
        this.originalModelProperties = new ArrayList<ModelProperty>(modelProperties);
        for (ModelContainerFactory factory : modelContainerFactories) {
            Collection<String> uris = factory.getUris();
            if (uris == null) {
                throw new IllegalArgumentException("factory.uris: null");
            }
            for (String uri : uris) {
                this.modelContainerFactoryMap.put(uri, factory);
            }
        }
    }

    @Override
    public String getEventHistory() {
        StringBuffer sb = new StringBuffer();
        sb.append("Original Model Properties\r\n");
        for (ModelProperty mp : this.originalModelProperties) {
            sb.append(mp).append("\r\n");
        }
        for (DataEvent de : this.dataEvents) {
            sb.append(de.toString());
        }
        sb.append("Processed Model Properties\r\n");
        for (ModelProperty mp : this.modelProperties) {
            sb.append(mp).append("\r\n");
        }
        return sb.toString();
    }

    protected static List<ModelProperty> mergeModelContainers(ModelContainer a, ModelContainer b) {
        ArrayList<ModelProperty> m = new ArrayList<ModelProperty>();
        m.addAll(a.getProperties());
        m.addAll(b.getProperties());
        ArrayList<String> combineChildrenUris = new ArrayList<String>();
        for (ModelProperty mp : m) {
            String x = mp.getUri();
            if (!x.endsWith("#property/combine.children") || !mp.getResolvedValue().equals("append")) continue;
            combineChildrenUris.add(x.substring(0, x.length() - 26));
        }
        LinkedList<ModelProperty> processedProperties = new LinkedList<ModelProperty>();
        ArrayList<String> uris = new ArrayList<String>();
        String baseUri = a.getProperties().get(0).getUri();
        for (ModelProperty p : m) {
            int modelPropertyLength = p.getUri().length();
            if (baseUri.length() > modelPropertyLength) {
                throw new IllegalArgumentException("Base URI is longer than model property uri: Base URI = " + baseUri + ", ModelProperty = " + p);
            }
            String subUri = p.getUri().substring(baseUri.length(), modelPropertyLength);
            if (uris.contains(p.getUri()) && (!subUri.contains("#collection") && !subUri.contains("#set") || subUri.endsWith("#collection") || subUri.endsWith("#set") || DefaultModelDataSource.isParentASet(subUri) || !DefaultModelDataSource.combineChildrenRule(p, combineChildrenUris))) continue;
            processedProperties.add(DefaultModelDataSource.findLastIndexOfParent(p, processedProperties) + 1, p);
            uris.add(p.getUri());
        }
        return processedProperties;
    }

    private static boolean combineChildrenRule(ModelProperty mp, List<String> combineChildrenUris) {
        return !combineChildrenUris.contains(mp.getUri()) || mp.getUri().endsWith("#property/combine.children");
    }

    private static boolean isParentASet(String uri) {
        String x = uri.replaceAll("#property", "").replaceAll("/combine.children", "");
        String parentUri = x.lastIndexOf("/") > 0 ? x.substring(0, x.lastIndexOf("/")) : "";
        return parentUri.endsWith("#set");
    }

    private List<ModelProperty> findUnknownModelPropertiesFrom(List<ModelContainer> modelContainers) {
        ArrayList<ModelProperty> unknownProperties = new ArrayList<ModelProperty>();
        for (ModelContainer mc : modelContainers) {
            if (this.modelProperties.containsAll(mc.getProperties())) continue;
            for (ModelProperty mp : mc.getProperties()) {
                if (this.modelProperties.contains(mp)) continue;
                unknownProperties.add(mp);
            }
        }
        return unknownProperties;
    }

    private static int findLastIndexOfParent(ModelProperty modelProperty, List<ModelProperty> modelProperties) {
        for (int i = modelProperties.size() - 1; i >= 0; --i) {
            if (modelProperties.get(i).getUri().equals(modelProperty.getUri())) {
                for (int j = i; j < modelProperties.size(); ++j) {
                    if (modelProperties.get(j).getUri().startsWith(modelProperty.getUri())) continue;
                    return j - 1;
                }
                return modelProperties.size() - 1;
            }
            if (!modelProperties.get(i).isParentOf(modelProperty)) continue;
            return i;
        }
        return -1;
    }

    private static boolean aContainsAnyOfB(List<ModelProperty> a, List<ModelProperty> b) {
        for (ModelProperty mp : b) {
            if (!a.contains(mp)) continue;
            return true;
        }
        return false;
    }

    protected static List<ModelProperty> sort(List<ModelProperty> properties, String baseUri) {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        LinkedList<ModelProperty> processedProperties = new LinkedList<ModelProperty>();
        ArrayList<String> position = new ArrayList<String>();
        boolean projectIsContained = false;
        for (ModelProperty p : properties) {
            String uri = p.getUri();
            String parentUri = uri.substring(0, uri.lastIndexOf("/"));
            if (!projectIsContained && uri.equals(baseUri)) {
                projectIsContained = true;
                processedProperties.add(p);
                position.add(0, uri);
                continue;
            }
            if (position.contains(uri) && !parentUri.contains("#collection") && !parentUri.contains("#set")) continue;
            int pst = parentUri.endsWith("#property") ? position.indexOf(parentUri.replaceAll("#property", "")) + 1 : position.indexOf(parentUri) + 1;
            processedProperties.add(pst, p);
            position.add(pst, uri);
        }
        return processedProperties;
    }

    private static String findBaseUriFrom(List<ModelProperty> modelProperties) {
        String baseUri = null;
        for (ModelProperty mp : modelProperties) {
            if (baseUri != null && mp.getUri().length() >= baseUri.length()) continue;
            baseUri = mp.getUri();
        }
        return baseUri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataEvent {
        private List<ModelProperty> removedModelProperties;
        private ModelContainer mcA;
        private ModelContainer mcB;
        private String methodName;

        DataEvent(ModelContainer mcA, ModelContainer mcB, List<ModelProperty> removedModelProperties, String methodName) {
            this.mcA = mcA;
            this.mcB = mcB;
            this.removedModelProperties = removedModelProperties;
            this.methodName = methodName;
        }

        public ModelContainer getMcA() {
            return this.mcA;
        }

        public ModelContainer getMcB() {
            return this.mcB;
        }

        public List<ModelProperty> getRemovedModelProperties() {
            return this.removedModelProperties;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Delete Event: ").append(this.methodName).append("\r\n");
            sb.append("Model Container A:\r\n");
            for (ModelProperty mp : this.mcA.getProperties()) {
                sb.append(mp).append("\r\n");
            }
            if (this.mcB != null) {
                sb.append("Model Container B:\r\n");
                for (ModelProperty mp : this.mcB.getProperties()) {
                    sb.append(mp).append("\r\n");
                }
            }
            sb.append("Removed Properties:\r\n");
            for (ModelProperty mp : this.removedModelProperties) {
                sb.append(mp).append("\r\n");
            }
            return sb.toString();
        }
    }
}

