/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.shared.model.InterpolatorProperty;

public final class ModelProperty {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.|env\\.)?([^}]+)\\}");
    private final String uri;
    private final String value;
    private final int depth;
    private String resolvedValue;
    private final List<String> unresolvedExpressions;

    public ModelProperty(String uri, String value) {
        String uriWithoutProperty;
        int index;
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        this.uri = uri;
        this.value = value;
        this.resolvedValue = value;
        this.unresolvedExpressions = new ArrayList<String>();
        if (value != null) {
            Matcher matcher = EXPRESSION_PATTERN.matcher(value);
            while (matcher.find()) {
                this.unresolvedExpressions.add(matcher.group(0));
            }
        }
        if ((index = uri.lastIndexOf("/")) > -1) {
            uriWithoutProperty = uri.substring(0, uri.lastIndexOf("/"));
            if (uriWithoutProperty.endsWith("#property") || uriWithoutProperty.endsWith("combine.children")) {
                uriWithoutProperty = uriWithoutProperty.substring(0, uriWithoutProperty.lastIndexOf("/"));
            }
        } else {
            uriWithoutProperty = uri;
        }
        this.depth = uriWithoutProperty.split("/").length;
    }

    public String getUri() {
        return this.uri;
    }

    public String getValue() {
        return this.value;
    }

    public String getResolvedValue() {
        if (this.resolvedValue != null && !this.resolvedValue.startsWith("<![CDATA[") && (this.resolvedValue.contains("=") || this.resolvedValue.contains("<"))) {
            this.resolvedValue = "<![CDATA[" + this.resolvedValue + "]]>";
        }
        return this.resolvedValue;
    }

    public boolean isResolved() {
        return this.unresolvedExpressions.isEmpty();
    }

    public ModelProperty createCopyOfOriginal() {
        return new ModelProperty(this.uri, this.value);
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isParentOf(ModelProperty modelProperty) {
        if (Math.abs(this.depth - modelProperty.getDepth()) > 1) {
            return false;
        }
        if (this.uri.equals(modelProperty.getUri()) || this.uri.startsWith(modelProperty.getUri())) {
            return false;
        }
        return modelProperty.getUri().startsWith(this.uri);
    }

    public InterpolatorProperty asInterpolatorProperty(String baseUri) {
        if (this.uri.contains("#collection") || this.uri.contains("#set") || this.value == null) {
            return null;
        }
        String key = "${" + this.uri.replace(baseUri + "/", "").replace("/", ".") + "}";
        return new InterpolatorProperty(key, this.value);
    }

    public void resolveWith(InterpolatorProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("property: null");
        }
        if (this.isResolved()) {
            return;
        }
        for (String expression : this.unresolvedExpressions) {
            if (!property.getKey().equals(expression)) continue;
            this.resolvedValue = this.resolvedValue.replace(property.getKey(), property.getValue());
            this.unresolvedExpressions.clear();
            Matcher matcher = EXPRESSION_PATTERN.matcher(this.resolvedValue);
            while (matcher.find()) {
                this.unresolvedExpressions.add(matcher.group(0));
            }
            break block0;
        }
    }

    public String toString() {
        return "Uri = " + this.uri + ", Value = " + this.value + ", Resolved Value = " + this.resolvedValue + ", Hash = " + this.hashCode();
    }
}

