/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="textFile")
public class TextFileExposer
implements JarIdentificationExposer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        List<String> textFiles = this.findTextFileVersions(jarAnalyzer);
        for (String ver : textFiles) {
            identification.addVersion(ver);
        }
    }

    private List<String> findTextFileVersions(JarAnalyzer jarAnalyzer) {
        ArrayList<String> textVersions = new ArrayList<String>();
        List<JarEntry> hits = jarAnalyzer.getVersionEntries();
        for (JarEntry entry : hits) {
            if (entry.getName().endsWith(".class")) continue;
            this.logger.debug("Version Hit: " + entry.getName());
            try {
                InputStream is = jarAnalyzer.getEntryInputStream(entry);
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String line = br.readLine();
                    this.logger.debug(line);
                    if (line == null || line.isEmpty()) continue;
                    textVersions.add(line);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                this.logger.warn("Unable to read line from " + entry.getName(), (Throwable)e);
            }
        }
        return textVersions;
    }
}

