/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal.maven30;

import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;

public class Maven3DirectScopeDependencySelector
implements DependencySelector {
    private final String scope;
    private final int depth;

    public Maven3DirectScopeDependencySelector(String scope) {
        this(scope, 0);
    }

    private Maven3DirectScopeDependencySelector(String scope, int depth) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null!");
        }
        this.scope = scope;
        this.depth = depth;
    }

    public boolean selectDependency(Dependency dependency) {
        return this.depth < 2 || !this.scope.equals(dependency.getScope());
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.depth >= 2) {
            return this;
        }
        return new Maven3DirectScopeDependencySelector(this.scope, this.depth + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.depth;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Maven3DirectScopeDependencySelector other = (Maven3DirectScopeDependencySelector)obj;
        if (this.depth != other.depth) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }
}

