/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Exclusion;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class DefaultDependencyNode
implements DependencyNode {
    private final Artifact artifact;
    private final DependencyNode parent;
    private final String premanagedVersion;
    private final String premanagedScope;
    private final String versionConstraint;
    private List<DependencyNode> children;
    private Boolean optional;
    private List<Exclusion> exclusions;

    public DefaultDependencyNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint) {
        this.parent = parent;
        this.artifact = artifact;
        this.premanagedVersion = premanagedVersion;
        this.premanagedScope = premanagedScope;
        this.versionConstraint = versionConstraint;
    }

    public DefaultDependencyNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint, Boolean optional, List<Exclusion> exclusions) {
        this.parent = parent;
        this.artifact = artifact;
        this.premanagedVersion = premanagedVersion;
        this.premanagedScope = premanagedScope;
        this.versionConstraint = versionConstraint;
        this.optional = optional;
        this.exclusions = exclusions;
    }

    public DefaultDependencyNode(Artifact artifact) {
        this.artifact = artifact;
        this.parent = null;
        this.premanagedScope = null;
        this.premanagedVersion = null;
        this.versionConstraint = null;
    }

    @Override
    public boolean accept(DependencyNodeVisitor visitor) {
        block1: {
            if (!visitor.visit(this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.endVisit(this);
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setChildren(List<DependencyNode> children) {
        this.children = children;
    }

    @Override
    public List<DependencyNode> getChildren() {
        return this.children;
    }

    @Override
    public DependencyNode getParent() {
        return this.parent;
    }

    @Override
    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    @Override
    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    @Override
    public String getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    @Override
    public String toNodeString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.artifact);
        return buffer.toString();
    }
}

