/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class DefaultDependencyNode
implements DependencyNode {
    private final Artifact artifact;
    private final DependencyNode parent;
    private final String premanagedVersion;
    private final String premanagedScope;
    private final String versionConstraint;
    private List<DependencyNode> children;
    private Boolean optional;

    public DefaultDependencyNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint) {
        this.parent = parent;
        this.artifact = artifact;
        this.premanagedVersion = premanagedVersion;
        this.premanagedScope = premanagedScope;
        this.versionConstraint = versionConstraint;
    }

    public DefaultDependencyNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint, Boolean optional) {
        this.parent = parent;
        this.artifact = artifact;
        this.premanagedVersion = premanagedVersion;
        this.premanagedScope = premanagedScope;
        this.versionConstraint = versionConstraint;
        this.optional = optional;
    }

    @Override
    public boolean accept(DependencyNodeVisitor visitor) {
        block1: {
            if (!visitor.visit(this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.endVisit(this);
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setChildren(List<DependencyNode> children) {
        this.children = children;
    }

    @Override
    public List<DependencyNode> getChildren() {
        return this.children;
    }

    @Override
    public DependencyNode getParent() {
        return this.parent;
    }

    @Override
    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    @Override
    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    @Override
    public String getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public String toNodeString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.artifact);
        ItemAppender appender = new ItemAppender(buffer, " (", "; ", ")");
        if (this.getPremanagedVersion() != null) {
            appender.append("version managed from ", this.getPremanagedVersion());
        }
        if (this.getPremanagedScope() != null) {
            appender.append("scope managed from ", this.getPremanagedScope());
        }
        if (this.getVersionConstraint() != null) {
            appender.append("version selected from constraint ", this.getVersionConstraint());
        }
        appender.flush();
        if (this.optional != null && this.optional.booleanValue()) {
            buffer.append(" (optional) ");
        }
        return buffer.toString();
    }

    private static class ItemAppender {
        private StringBuffer buffer;
        private String startToken;
        private String separatorToken;
        private String endToken;
        private boolean appended;

        ItemAppender(StringBuffer buffer, String startToken, String separatorToken, String endToken) {
            this.buffer = buffer;
            this.startToken = startToken;
            this.separatorToken = separatorToken;
            this.endToken = endToken;
            this.appended = false;
        }

        public ItemAppender append(String item1, String item2) {
            this.appendToken();
            this.buffer.append(item1).append(item2);
            return this;
        }

        public void flush() {
            if (this.appended) {
                this.buffer.append(this.endToken);
                this.appended = false;
            }
        }

        private void appendToken() {
            this.buffer.append(this.appended ? this.separatorToken : this.startToken);
            this.appended = true;
        }
    }
}

