/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    private ClassAnalyzer classAnalyzer;
    private DependencyAnalyzer dependencyAnalyzer;

    public ProjectDependencyAnalysis analyze(MavenProject project) throws ProjectDependencyAnalyzerException {
        try {
            Map artifactClassMap = this.buildArtifactClassMap(project);
            Set dependencyClasses = this.buildDependencyClasses(project);
            Set declaredArtifacts = project.getDependencyArtifacts();
            HashSet<Artifact> usedArtifacts = new HashSet<Artifact>();
            Iterator dependencyIterator = dependencyClasses.iterator();
            while (dependencyIterator.hasNext()) {
                String className = (String)dependencyIterator.next();
                Artifact artifact = this.findArtifactForClassName(artifactClassMap, className);
                if (artifact == null) continue;
                usedArtifacts.add(artifact);
            }
            HashSet usedDeclaredArtifacts = new HashSet(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts);
            HashSet usedUndeclaredArtifacts = new HashSet(usedArtifacts);
            usedUndeclaredArtifacts.removeAll(declaredArtifacts);
            HashSet unusedDeclaredArtifacts = new HashSet(declaredArtifacts);
            unusedDeclaredArtifacts.removeAll(usedArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifacts, usedUndeclaredArtifacts, unusedDeclaredArtifacts);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private Map buildArtifactClassMap(MavenProject project) throws IOException {
        HashMap<Artifact, Set> artifactClassMap = new HashMap<Artifact, Set>();
        Set dependencyArtifacts = project.getArtifacts();
        Iterator iterator = dependencyArtifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            File file = artifact.getFile();
            if (file == null) continue;
            URL url = file.toURL();
            Set classes = this.classAnalyzer.analyze(url);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    private Set buildDependencyClasses(MavenProject project) throws IOException {
        String buildDirectory = project.getBuild().getDirectory();
        URL buildDirectoryURL = new File(buildDirectory).toURI().toURL();
        return this.dependencyAnalyzer.analyze(buildDirectoryURL);
    }

    private Artifact findArtifactForClassName(Map artifactClassMap, String className) {
        Iterator artifactIterator = artifactClassMap.keySet().iterator();
        while (artifactIterator.hasNext()) {
            Artifact artifact = (Artifact)artifactIterator.next();
            Set artifactClassNames = (Set)artifactClassMap.get(artifact);
            Iterator classNameIterator = artifactClassNames.iterator();
            while (classNameIterator.hasNext()) {
                String artifactClassName = (String)classNameIterator.next();
                if (!artifactClassName.equals(className)) continue;
                return artifact;
            }
        }
        return null;
    }
}

