/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.add;

import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class JGitAddCommand
extends AbstractAddCommand
implements GitCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to add (e.g. -Dincludes=...)");
        }
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            List<ScmFile> addedFiles = JGitUtils.addAllFiles(git, fileSet);
            if (this.logger.isDebugEnabled()) {
                for (ScmFile scmFile : addedFiles) {
                    this.logger.info("added file: " + scmFile);
                }
            }
            AddScmResult addScmResult = new AddScmResult("JGit add", addedFiles);
            return addScmResult;
        }
        catch (IOException | GitAPIException e) {
            throw new ScmException("JGit add failure!", e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

