/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class NodeListGenerator
implements Consumer<DependencyNode> {
    private final ArrayList<DependencyNode> nodes = new ArrayList(128);

    @Override
    public void accept(DependencyNode dependencyNode) {
        this.nodes.add(dependencyNode);
    }

    public List<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<DependencyNode> getNodesWithDependencies() {
        return NodeListGenerator.getNodesWithDependencies(this.getNodes());
    }

    public List<Dependency> getDependencies(boolean includeUnresolved) {
        return NodeListGenerator.getDependencies(this.getNodes(), includeUnresolved);
    }

    public List<Artifact> getArtifacts(boolean includeUnresolved) {
        return NodeListGenerator.getArtifacts(this.getNodes(), includeUnresolved);
    }

    public List<File> getFiles() {
        return NodeListGenerator.getFiles(this.getNodes());
    }

    public String getClassPath() {
        return NodeListGenerator.getClassPath(this.getNodes());
    }

    static List<DependencyNode> getNodesWithDependencies(List<DependencyNode> nodes) {
        return nodes.stream().filter(d -> d.getDependency() != null).collect(Collectors.toList());
    }

    static List<Dependency> getDependencies(List<DependencyNode> nodes, boolean includeUnresolved) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(nodes.size());
        for (DependencyNode node : NodeListGenerator.getNodesWithDependencies(nodes)) {
            Dependency dependency = node.getDependency();
            if (!includeUnresolved && dependency.getArtifact().getFile() == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    static List<Artifact> getArtifacts(List<DependencyNode> nodes, boolean includeUnresolved) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(nodes.size());
        for (DependencyNode node : NodeListGenerator.getNodesWithDependencies(nodes)) {
            Artifact artifact = node.getDependency().getArtifact();
            if (!includeUnresolved && artifact.getFile() == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    static List<File> getFiles(List<DependencyNode> nodes) {
        ArrayList<File> files = new ArrayList<File>(nodes.size());
        for (DependencyNode node : NodeListGenerator.getNodesWithDependencies(nodes)) {
            File file = node.getDependency().getArtifact().getFile();
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    static String getClassPath(List<DependencyNode> nodes) {
        StringBuilder buffer = new StringBuilder(1024);
        Iterator<DependencyNode> it = NodeListGenerator.getNodesWithDependencies(nodes).iterator();
        while (it.hasNext()) {
            DependencyNode node = it.next();
            Artifact artifact = node.getDependency().getArtifact();
            if (artifact.getFile() == null) continue;
            buffer.append(artifact.getFile().getAbsolutePath());
            if (!it.hasNext()) continue;
            buffer.append(File.pathSeparatorChar);
        }
        return buffer.toString();
    }
}

