/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

public class DependencyGraphDumper
implements DependencyVisitor {
    private final Consumer<String> consumer;
    private final Deque<DependencyNode> nodes = new ArrayDeque<DependencyNode>();

    public DependencyGraphDumper(Consumer<String> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public boolean visitEnter(DependencyNode node) {
        this.nodes.push(node);
        this.consumer.accept(this.formatLine(this.nodes));
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        if (!this.nodes.isEmpty()) {
            this.nodes.pop();
        }
        return true;
    }

    protected String formatLine(Deque<DependencyNode> nodes) {
        return this.formatIndentation(nodes) + this.formatNode(nodes);
    }

    protected String formatIndentation(Deque<DependencyNode> nodes) {
        DependencyNode child;
        StringBuilder buffer = new StringBuilder(128);
        Iterator<DependencyNode> iter = nodes.descendingIterator();
        DependencyNode parent = iter.hasNext() ? iter.next() : null;
        DependencyNode dependencyNode = child = iter.hasNext() ? iter.next() : null;
        while (parent != null && child != null) {
            boolean end;
            boolean lastChild = parent.getChildren().get(parent.getChildren().size() - 1) == child;
            boolean bl = end = child == nodes.peekFirst();
            String indent = end ? (lastChild ? "\\- " : "+- ") : (lastChild ? "   " : "|  ");
            buffer.append(indent);
            parent = child;
            child = iter.hasNext() ? iter.next() : null;
        }
        return buffer.toString();
    }

    protected String formatNode(Deque<DependencyNode> nodes) {
        DependencyNode winner;
        String premanaged;
        DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug: should not happen");
        StringBuilder buffer = new StringBuilder(128);
        Artifact a = node.getArtifact();
        buffer.append(a);
        Dependency d = node.getDependency();
        if (d != null && !d.getScope().isEmpty()) {
            buffer.append(" [").append(d.getScope());
            if (d.isOptional()) {
                buffer.append(", optional");
            }
            buffer.append("]");
        }
        if ((premanaged = DependencyManagerUtils.getPremanagedVersion(node)) != null && !premanaged.equals(a.getBaseVersion())) {
            buffer.append(" (version managed from ").append(premanaged).append(")");
        }
        if ((premanaged = DependencyManagerUtils.getPremanagedScope(node)) != null && d != null && !premanaged.equals(d.getScope())) {
            buffer.append(" (scope managed from ").append(premanaged).append(")");
        }
        if ((winner = (DependencyNode)node.getData().get("conflict.winner")) != null) {
            if (ArtifactIdUtils.equalsId(a, winner.getArtifact())) {
                buffer.append(" (nearer exists)");
            } else {
                Artifact w = winner.getArtifact();
                buffer.append(" (conflicts with ");
                if (ArtifactIdUtils.toVersionlessId(a).equals(ArtifactIdUtils.toVersionlessId(w))) {
                    buffer.append(w.getVersion());
                } else {
                    buffer.append(w);
                }
                buffer.append(")");
            }
        }
        return buffer.toString();
    }
}

