/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

class ArtifactDefinition {
    private String groupId;
    private String artifactId;
    private String extension;
    private String version;
    private String scope = "";
    private String definition;
    private String id;
    private String reference;
    private Boolean optional;

    ArtifactDefinition(String def) {
        this.definition = def.trim();
        if (this.definition.startsWith("(")) {
            int idx = this.definition.indexOf(41);
            this.id = this.definition.substring(1, idx);
            this.definition = this.definition.substring(idx + 1);
        } else if (this.definition.startsWith("^")) {
            this.reference = this.definition.substring(1);
            return;
        }
        String[] split = this.definition.split(":");
        if (split.length < 4) {
            throw new IllegalArgumentException("Need definition like 'gid:aid:ext:ver[:scope]', but was: " + this.definition);
        }
        this.groupId = split[0];
        this.artifactId = split[1];
        this.extension = split[2];
        this.version = split[3];
        if (split.length > 4) {
            this.scope = split[4];
        }
        if (split.length > 5) {
            if ("optional".equalsIgnoreCase(split[5])) {
                this.optional = true;
            } else if ("!optional".equalsIgnoreCase(split[5])) {
                this.optional = false;
            }
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return this.definition;
    }

    public String getId() {
        return this.id;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public Boolean getOptional() {
        return this.optional;
    }
}

