/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Comparator;
import java.util.stream.Collectors;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.BuildScopeQuery;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ManagedScopeDeriver;
import org.eclipse.aether.internal.impl.scope.ScopeManagerImpl;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.scope.ResolutionScope;

public final class ScopeManagerDump {
    public static void dump(ScopeManagerConfiguration configuration) {
        new ScopeManagerDump(configuration);
    }

    private ScopeManagerDump(ScopeManagerConfiguration configuration) {
        ScopeManagerImpl scopeManager = new ScopeManagerImpl(configuration);
        System.out.println();
        this.dumpBuildScopes(scopeManager);
        System.out.println();
        this.dumpDependencyScopes(scopeManager);
        System.out.println();
        this.dumpDependencyScopeDerives(scopeManager);
        System.out.println();
        this.dumpResolutionScopes(scopeManager);
    }

    private void dumpBuildScopes(ScopeManagerImpl scopeManager) {
        System.out.println(scopeManager.getId() + " defined build scopes:");
        scopeManager.getBuildScopeSource().query(BuildScopeQuery.all()).stream().sorted(Comparator.comparing(BuildScope::order)).forEach(s -> System.out.println(s.getId() + " (order=" + s.order() + ")"));
    }

    private void dumpDependencyScopes(ScopeManagerImpl scopeManager) {
        System.out.println(scopeManager.getId() + " defined dependency scopes:");
        scopeManager.getDependencyScopeUniverse().stream().sorted(Comparator.comparing(scopeManager::getDependencyScopeWidth).reversed()).forEach(s -> {
            System.out.println(s + " (width=" + scopeManager.getDependencyScopeWidth((DependencyScope)s) + ")");
            System.out.println("  Query : " + scopeManager.getPresence((DependencyScope)s));
            System.out.println("  Presence: " + scopeManager.getBuildScopeSource().query(scopeManager.getPresence((DependencyScope)s)).stream().map(BuildScope::getId).collect(Collectors.toSet()));
            System.out.println("  Main project scope: " + scopeManager.getDependencyScopeMainProjectBuildScope((DependencyScope)s).map(BuildScope::getId).orElse("null"));
        });
    }

    private void dumpDependencyScopeDerives(ScopeManagerImpl scopeManager) {
        System.out.println(scopeManager.getId() + " defined dependency derive matrix:");
        ManagedScopeDeriver deriver = new ManagedScopeDeriver(scopeManager);
        scopeManager.getDependencyScopeUniverse().stream().sorted(Comparator.comparing(scopeManager::getDependencyScopeWidth).reversed()).forEach(parent -> scopeManager.getDependencyScopeUniverse().stream().sorted(Comparator.comparing(scopeManager::getDependencyScopeWidth).reversed()).forEach(child -> System.out.println(parent.getId() + " w/ child " + child.getId() + " -> " + deriver.getDerivedScope(parent.getId(), child.getId()))));
    }

    private void dumpResolutionScopes(ScopeManagerImpl scopeManager) {
        System.out.println(scopeManager.getId() + " defined resolution scopes:");
        scopeManager.getResolutionScopeUniverse().stream().sorted(Comparator.comparing(ResolutionScope::getId)).forEach(s -> {
            System.out.println("* " + s.getId());
            System.out.println("     Directly included: " + scopeManager.getDirectlyIncludedLabels((ResolutionScope)s));
            System.out.println("     Directly excluded: " + scopeManager.getDirectlyExcludedLabels((ResolutionScope)s));
            System.out.println(" Transitively excluded: " + scopeManager.getTransitivelyExcludedLabels((ResolutionScope)s));
        });
    }
}

