/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.DefaultArtifactPredicate;
import org.eclipse.aether.spi.artifact.ArtifactPredicate;
import org.eclipse.aether.spi.artifact.ArtifactPredicateFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named
public final class DefaultArtifactPredicateFactory
implements ArtifactPredicateFactory {
    private static final String CONFIG_PROPS_PREFIX = "aether.checksums.";
    public static final String CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS = "aether.checksums.omitChecksumsForExtensions";
    public static final String DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS = ".asc,.sigstore";
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Inject
    public DefaultArtifactPredicateFactory(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.checksumAlgorithmFactorySelector = checksumAlgorithmFactorySelector;
    }

    public ArtifactPredicate newInstance(RepositorySystemSession session) {
        Set<String> omitChecksumsForExtensions = Arrays.stream(ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_OMIT_CHECKSUMS_FOR_EXTENSIONS, (String[])new String[]{CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS}).split(",")).filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.toSet());
        if (omitChecksumsForExtensions.stream().anyMatch(s -> !s.startsWith("."))) {
            throw new IllegalArgumentException(String.format("The configuration %s contains illegal values: %s (all entries must start with '.' (dot))", CONFIG_PROP_OMIT_CHECKSUMS_FOR_EXTENSIONS, omitChecksumsForExtensions));
        }
        return new DefaultArtifactPredicate(this.checksumAlgorithmFactorySelector, omitChecksumsForExtensions);
    }
}

