/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl.scope;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.ProjectPath;

public final class CommonBuilds {
    public static final ProjectPath PROJECT_PATH_MAIN = new ProjectPathImpl("main", 1, 3);
    public static final ProjectPath PROJECT_PATH_TEST = new ProjectPathImpl("test", 2, 1);
    public static final ProjectPath PROJECT_PATH_IT = new ProjectPathImpl("it", 3, 2);
    public static final BuildPath BUILD_PATH_PREPROCESS = new BuildPathImpl("preprocess", false, 1);
    public static final BuildPath BUILD_PATH_COMPILE = new BuildPathImpl("compile", false, 2);
    public static final BuildPath BUILD_PATH_RUNTIME = new BuildPathImpl("runtime", true, 3);
    public static final BuildScope MAVEN_TEST_BUILD_SCOPE = new BuildScopeImpl("test", Collections.singleton(PROJECT_PATH_TEST), Collections.unmodifiableSet(new HashSet<BuildPath>(Arrays.asList(BUILD_PATH_COMPILE, BUILD_PATH_RUNTIME))), 10);

    private CommonBuilds() {
    }

    private static final class ProjectPathImpl
    extends Label
    implements ProjectPath {
        private final int order;
        private final int reverseOrder;

        private ProjectPathImpl(String id, int order, int reverseOrder) {
            super(id);
            this.order = order;
            this.reverseOrder = reverseOrder;
        }

        @Override
        public int order() {
            return this.order;
        }

        @Override
        public int reverseOrder() {
            return this.reverseOrder;
        }
    }

    private static final class BuildPathImpl
    extends Label
    implements BuildPath {
        private final boolean reverse;
        private final int order;

        private BuildPathImpl(String id, boolean reverse, int order) {
            super(id);
            this.reverse = reverse;
            this.order = order;
        }

        @Override
        public boolean isReverse() {
            return this.reverse;
        }

        @Override
        public int order() {
            return this.order;
        }
    }

    private static final class BuildScopeImpl
    extends Label
    implements BuildScope {
        private final Set<ProjectPath> projectPaths;
        private final Set<BuildPath> buildPaths;
        private final int order;

        private BuildScopeImpl(String id, Set<ProjectPath> projectPaths, Set<BuildPath> buildPaths, int order) {
            super(id);
            this.projectPaths = projectPaths;
            this.buildPaths = buildPaths;
            this.order = order;
        }

        @Override
        public Set<ProjectPath> getProjectPaths() {
            return this.projectPaths;
        }

        @Override
        public Set<BuildPath> getBuildPaths() {
            return this.buildPaths;
        }

        @Override
        public int order() {
            return this.order;
        }
    }

    private static abstract class Label {
        private final String id;

        protected Label(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Label label = (Label)o;
            return Objects.equals(this.id, label.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }
    }
}

