/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import org.eclipse.aether.internal.impl.DefaultRepositoryKeyFunctionFactory;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.eclipse.aether.util.repository.RepositoryIdHelper;

@Singleton
@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory {
    public static final String NAME = "simple";
    private float priority;
    private final LocalPathComposer localPathComposer;
    private final RepositoryKeyFunctionFactory repositoryKeyFunctionFactory;

    public SimpleLocalRepositoryManagerFactory() {
        this.localPathComposer = new DefaultLocalPathComposer();
        this.repositoryKeyFunctionFactory = new DefaultRepositoryKeyFunctionFactory();
    }

    @Inject
    public SimpleLocalRepositoryManagerFactory(LocalPathComposer localPathComposer, RepositoryKeyFunctionFactory repositoryKeyFunctionFactory) {
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.repositoryKeyFunctionFactory = Objects.requireNonNull(repositoryKeyFunctionFactory);
    }

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if ("".equals(repository.getContentType()) || NAME.equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasePath(), NAME, this.localPathComposer, this.repositoryKeyFunctionFactory.repositoryKeyFunction(SimpleLocalRepositoryManagerFactory.class, session, RepositoryIdHelper.RepositoryKeyType.SIMPLE.name(), null));
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public float getPriority() {
        return this.priority;
    }

    public SimpleLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

