/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryKeyFunction;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;
    private final LocalPathComposer localPathComposer;
    private final RepositoryKeyFunction repositoryKeyFunction;

    SimpleLocalRepositoryManager(Path basePath, String type, LocalPathComposer localPathComposer, RepositoryKeyFunction repositoryKeyFunction) {
        Objects.requireNonNull(basePath, "base directory cannot be null");
        this.repository = new LocalRepository(basePath.toAbsolutePath(), type);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.repositoryKeyFunction = Objects.requireNonNull(repositoryKeyFunction);
    }

    public LocalRepository getRepository() {
        return this.repository;
    }

    public String getPathForLocalArtifact(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, true);
    }

    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForArtifact(artifact, false);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, "local");
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        Objects.requireNonNull(metadata, "metadata cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return this.localPathComposer.getPathForMetadata(metadata, this.getRepositoryKey(repository, context));
    }

    protected String getRepositoryKey(RemoteRepository repository, String context) {
        return this.repositoryKeyFunction.apply(repository, context);
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        Path filePath;
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        Artifact artifact = request.getArtifact();
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (Objects.equals(artifact.getVersion(), artifact.getBaseVersion()) && Files.isRegularFile(filePath = this.getAbsolutePathForLocalArtifact(artifact), new LinkOption[0])) {
            result.setPath(filePath);
            result.setAvailable(true);
        }
        if (!result.isAvailable()) {
            for (RemoteRepository repository : request.getRepositories()) {
                filePath = this.getAbsolutePathForRemoteArtifact(artifact, repository, request.getContext());
                if (!Files.isRegularFile(filePath, new LinkOption[0])) continue;
                result.setPath(filePath);
                result.setAvailable(true);
                break;
            }
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        Path filePath = this.getRepository().getBasePath().resolve(path);
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            result.setPath(filePath);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }
}

