/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RepositoryKeyFunction;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.RepositoryIdHelper;

@Singleton
@Named
public class DefaultRepositoryKeyFunctionFactory
implements RepositoryKeyFunctionFactory {
    public RepositoryKeyFunction systemRepositoryKeyFunction(RepositorySystemSession session) {
        return this.repositoryKeyFunction(DefaultRepositoryKeyFunctionFactory.class, session, "nid", "aether.system.repositoryKeyFunction");
    }

    public RepositoryKeyFunction repositoryKeyFunction(Class<?> owner, RepositorySystemSession session, String defaultValue, String configurationKey) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(defaultValue);
        RepositoryKeyFunction repositoryKeyFunction = RepositoryIdHelper.getRepositoryKeyFunction((String)(configurationKey != null ? ConfigUtils.getString((RepositorySystemSession)session, (String)defaultValue, (String[])new String[]{configurationKey}) : defaultValue));
        if (session.getCache() != null) {
            return (repository, context) -> ((ConcurrentMap)session.getCache().computeIfAbsent(session, (Object)(owner.getName() + ".repositoryKeyFunction"), ConcurrentHashMap::new)).computeIfAbsent(repository, k1 -> new ConcurrentHashMap()).computeIfAbsent(context == null ? "" : context, k2 -> repositoryKeyFunction.apply(repository, context));
        }
        return repositoryKeyFunction;
    }
}

