/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.SystemScopeHandler;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.listener.ChainedTransferListener;

public final class DefaultCloseableSession
implements RepositorySystemSession.CloseableSession {
    private final String sessionId;
    private final AtomicBoolean closed;
    private final boolean offline;
    private final boolean ignoreArtifactDescriptorRepositories;
    private final ResolutionErrorPolicy resolutionErrorPolicy;
    private final ArtifactDescriptorPolicy artifactDescriptorPolicy;
    private final String checksumPolicy;
    private final String artifactUpdatePolicy;
    private final String metadataUpdatePolicy;
    private final LocalRepositoryManager localRepositoryManager;
    private final WorkspaceReader workspaceReader;
    private final RepositoryListener repositoryListener;
    private final TransferListener transferListener;
    private final Map<String, String> systemProperties;
    private final Map<String, String> userProperties;
    private final Map<String, Object> configProperties;
    private final MirrorSelector mirrorSelector;
    private final ProxySelector proxySelector;
    private final AuthenticationSelector authenticationSelector;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final DependencyTraverser dependencyTraverser;
    private final DependencyManager dependencyManager;
    private final DependencySelector dependencySelector;
    private final VersionFilter versionFilter;
    private final DependencyGraphTransformer dependencyGraphTransformer;
    private final SessionData data;
    private final RepositoryCache cache;
    private final SystemScopeHandler systemScopeHandler;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemLifecycle repositorySystemLifecycle;

    public DefaultCloseableSession(String sessionId, boolean offline, boolean ignoreArtifactDescriptorRepositories, ResolutionErrorPolicy resolutionErrorPolicy, ArtifactDescriptorPolicy artifactDescriptorPolicy, String checksumPolicy, String artifactUpdatePolicy, String metadataUpdatePolicy, LocalRepositoryManager localRepositoryManager, Collection<LocalRepository> localRepositories, WorkspaceReader workspaceReader, Collection<RepositoryListener> repositoryListener, Collection<TransferListener> transferListener, Map<String, String> systemProperties, Map<String, String> userProperties, Map<String, Object> configProperties, MirrorSelector mirrorSelector, ProxySelector proxySelector, AuthenticationSelector authenticationSelector, ArtifactTypeRegistry artifactTypeRegistry, DependencyTraverser dependencyTraverser, DependencyManager dependencyManager, DependencySelector dependencySelector, VersionFilter versionFilter, DependencyGraphTransformer dependencyGraphTransformer, SessionData data, RepositoryCache cache, SystemScopeHandler systemScopeHandler, List<Runnable> onSessionEndedHandlers, RepositorySystem repositorySystem, RepositorySystemLifecycle repositorySystemLifecycle) {
        this.sessionId = Objects.requireNonNull(sessionId);
        this.closed = new AtomicBoolean(false);
        this.offline = offline;
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        this.resolutionErrorPolicy = resolutionErrorPolicy;
        this.artifactDescriptorPolicy = artifactDescriptorPolicy;
        this.checksumPolicy = checksumPolicy;
        this.artifactUpdatePolicy = artifactUpdatePolicy;
        this.metadataUpdatePolicy = metadataUpdatePolicy;
        this.workspaceReader = workspaceReader;
        this.repositoryListener = new ChainedRepositoryListener(repositoryListener);
        this.transferListener = new ChainedTransferListener(transferListener);
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
        this.userProperties = Collections.unmodifiableMap(userProperties);
        this.configProperties = Collections.unmodifiableMap(configProperties);
        this.mirrorSelector = Objects.requireNonNull(mirrorSelector);
        this.proxySelector = Objects.requireNonNull(proxySelector);
        this.authenticationSelector = Objects.requireNonNull(authenticationSelector);
        this.artifactTypeRegistry = Objects.requireNonNull(artifactTypeRegistry);
        this.dependencyTraverser = dependencyTraverser;
        this.dependencyManager = dependencyManager;
        this.dependencySelector = dependencySelector;
        this.versionFilter = versionFilter;
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        this.data = Objects.requireNonNull(data);
        this.cache = cache;
        this.systemScopeHandler = Objects.requireNonNull(systemScopeHandler);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.localRepositoryManager = this.getOrCreateLocalRepositoryManager(localRepositoryManager, localRepositories);
        repositorySystemLifecycle.sessionStarted(this);
        onSessionEndedHandlers.forEach(this::addOnSessionEndedHandler);
    }

    private LocalRepositoryManager getOrCreateLocalRepositoryManager(LocalRepositoryManager localRepositoryManager, Collection<LocalRepository> localRepositories) {
        if (localRepositoryManager != null) {
            return localRepositoryManager;
        }
        if (localRepositories != null) {
            return this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this, new ArrayList<LocalRepository>(localRepositories));
        }
        throw new IllegalStateException("No local repository manager or local repositories set on session");
    }

    public String sessionId() {
        return this.sessionId;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.resolutionErrorPolicy;
    }

    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return this.artifactDescriptorPolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String getUpdatePolicy() {
        return this.getArtifactUpdatePolicy();
    }

    public String getArtifactUpdatePolicy() {
        return this.artifactUpdatePolicy;
    }

    public String getMetadataUpdatePolicy() {
        return this.metadataUpdatePolicy;
    }

    public LocalRepository getLocalRepository() {
        return this.getLocalRepositoryManager().getRepository();
    }

    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepositoryManager;
    }

    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public DependencyTraverser getDependencyTraverser() {
        return this.dependencyTraverser;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public DependencySelector getDependencySelector() {
        return this.dependencySelector;
    }

    public VersionFilter getVersionFilter() {
        return this.versionFilter;
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.dependencyGraphTransformer;
    }

    public SessionData getData() {
        return this.data;
    }

    public RepositoryCache getCache() {
        return this.cache;
    }

    public SystemScopeHandler getSystemScopeHandler() {
        return this.systemScopeHandler;
    }

    public boolean addOnSessionEndedHandler(Runnable handler) {
        this.throwIfClosed();
        this.repositorySystemLifecycle.addOnSessionEndedHandle(this, handler);
        return true;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.repositorySystemLifecycle.sessionEnded(this);
        }
    }

    private void throwIfClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Session " + this.sessionId + " already closed");
        }
    }
}

