/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.version;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.spi.version.VersionSchemeSelector;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.version.VersionScheme;

@Singleton
@Named
public class DefaultVersionSchemeSelector
implements VersionSchemeSelector {
    static final String CONFIG_PROPS_PREFIX = "aether.versionScheme.";
    public static final String CONFIG_PROP_VERSION_SCHEME_NAME = "aether.versionScheme.name";
    public static final String DEFAULT_VERSION_SCHEME_NAME = "generic";
    private final Map<String, VersionScheme> versionSchemes;

    @Inject
    public DefaultVersionSchemeSelector(Map<String, VersionScheme> versionSchemes) {
        this.versionSchemes = Objects.requireNonNull(versionSchemes);
    }

    public VersionScheme selectVersionScheme(String schemeName) {
        Objects.requireNonNull(schemeName, "null schemeName");
        VersionScheme versionScheme = this.versionSchemes.get(schemeName);
        if (versionScheme == null) {
            throw new IllegalArgumentException("scheme not supported");
        }
        return versionScheme;
    }

    public VersionScheme selectVersionScheme(RepositorySystemSession session) {
        return this.selectVersionScheme(ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_VERSION_SCHEME_NAME, (String[])new String[]{CONFIG_PROP_VERSION_SCHEME_NAME}));
    }

    public Map<String, VersionScheme> getVersionSchemes() {
        return Collections.unmodifiableMap(this.versionSchemes);
    }
}

