/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.NodeStack;
import org.eclipse.aether.util.ConfigUtils;

class Results {
    private final CollectResult result;
    private final int maxExceptions;
    private final int maxCycles;
    String errorPath;

    Results(CollectResult result, RepositorySystemSession session) {
        this.result = result;
        this.maxExceptions = ConfigUtils.getInteger((RepositorySystemSession)session, (int)50, (String[])new String[]{"aether.dependencyCollector.maxExceptions"});
        this.maxCycles = ConfigUtils.getInteger((RepositorySystemSession)session, (int)10, (String[])new String[]{"aether.dependencyCollector.maxCycles"});
    }

    public void addException(Dependency dependency, Exception e, NodeStack nodes) {
        if (this.maxExceptions < 0 || this.result.getExceptions().size() < this.maxExceptions) {
            this.result.addException(e);
            if (this.errorPath == null) {
                StringBuilder buffer = new StringBuilder(256);
                for (int i = 0; i < nodes.size(); ++i) {
                    Dependency dep;
                    if (buffer.length() > 0) {
                        buffer.append(" -> ");
                    }
                    if ((dep = nodes.get(i).getDependency()) == null) continue;
                    buffer.append(dep.getArtifact());
                }
                if (buffer.length() > 0) {
                    buffer.append(" -> ");
                }
                buffer.append(dependency.getArtifact());
                this.errorPath = buffer.toString();
            }
        }
    }

    public void addCycle(NodeStack nodes, int cycleEntry, Dependency dependency) {
        if (this.maxCycles < 0 || this.result.getCycles().size() < this.maxCycles) {
            this.result.addCycle((DependencyCycle)new DefaultDependencyCycle(nodes, cycleEntry, dependency));
        }
    }
}

