/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;

@Singleton
@Named(value="remove-scm-tag")
public class RemoveScmTagPhase
extends AbstractReleasePhase {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Inject
    public RemoveScmTagPhase(ScmRepositoryConfigurator scmRepositoryConfigurator) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        UntagScmResult untagScmResult;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult releaseResult = new ReleaseResult();
        this.validateConfiguration(releaseDescriptor);
        this.logInfo(releaseResult, "Removing tag with the label " + releaseDescriptor.getScmReleaseLabel() + " ...");
        ReleaseDescriptor basedirAlignedReleaseDescriptor = ReleaseUtil.createBasedirAlignedReleaseDescriptor(releaseDescriptor, reactorProjects);
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(basedirAlignedReleaseDescriptor.getScmSourceUrl(), releaseDescriptor, releaseEnvironment.getSettings());
            repository.getProviderRepository().setPushChanges(releaseDescriptor.isPushChanges());
            repository.getProviderRepository().setWorkItem(releaseDescriptor.getWorkItem());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(new File(basedirAlignedReleaseDescriptor.getWorkingDirectory()));
            String tagName = releaseDescriptor.getScmReleaseLabel();
            String message = releaseDescriptor.getScmCommentPrefix() + "remove tag " + tagName;
            CommandParameters commandParameters = new CommandParameters();
            commandParameters.setString(CommandParameter.TAG_NAME, tagName);
            commandParameters.setString(CommandParameter.MESSAGE, message);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("RemoveScmTagPhase :: scmUntagParameters tagName " + tagName);
                this.getLogger().debug("RemoveScmTagPhase :: scmUntagParameters message " + message);
                this.getLogger().debug("RemoveScmTagPhase :: fileSet  " + fileSet);
            }
            untagScmResult = provider.untag(repository, fileSet, commandParameters);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error has occurred in the remove tag process: " + e.getMessage(), (Throwable)e);
        }
        if (!untagScmResult.isSuccess()) {
            this.getLogger().warn(String.format("Unable to remove tag%nProvider message: %s%nCommand output: %s", untagScmResult.getProviderMessage(), untagScmResult.getCommandOutput()));
        }
        releaseResult.setResultCode(0);
        return releaseResult;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult releaseResult = new ReleaseResult();
        this.validateConfiguration(releaseDescriptor);
        this.logInfo(releaseResult, "Full run would remove tag with label: '" + releaseDescriptor.getScmReleaseLabel() + "'");
        releaseResult.setResultCode(0);
        return releaseResult;
    }

    private void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for removal");
        }
    }
}

