/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseBranchRequest;
import org.apache.maven.shared.release.ReleaseCleanRequest;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleasePerformRequest;
import org.apache.maven.shared.release.ReleasePrepareRequest;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.ReleaseRollbackRequest;
import org.apache.maven.shared.release.ReleaseUpdateVersionsRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReleaseManager
extends AbstractLogEnabled
implements ReleaseManager {
    private List<String> preparePhases;
    private List<String> performPhases;
    private List<String> rollbackPhases;
    private List<String> branchPhases;
    private List<String> updateVersionsPhases;
    private Map<String, ReleasePhase> releasePhases;
    private ReleaseDescriptorStore configStore;
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private static final int PHASE_SKIP = 0;
    private static final int PHASE_START = 1;
    private static final int PHASE_END = 2;
    private static final int GOAL_START = 11;
    private static final int GOAL_END = 12;
    private static final int ERROR = 99;

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, true, false, null);
    }

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean resume, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult prepareWithResult(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) {
        ReleaseResult result = new ReleaseResult();
        result.setStartTime(System.currentTimeMillis());
        try {
            this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, listener, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException e) {
            this.captureException(result, listener, e);
        }
        catch (ReleaseFailureException e) {
            this.captureException(result, listener, e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, listener, null);
    }

    @Override
    public void prepare(ReleasePrepareRequest prepareRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(prepareRequest, new ReleaseResult());
    }

    private void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        ReleasePrepareRequest prepareRequest = new ReleasePrepareRequest();
        prepareRequest.setReleaseDescriptor(releaseDescriptor);
        prepareRequest.setReleaseEnvironment(releaseEnvironment);
        prepareRequest.setReactorProjects(reactorProjects);
        prepareRequest.setResume(resume);
        prepareRequest.setDryRun(dryRun);
        prepareRequest.setReleaseManagerListener(listener);
        this.prepare(prepareRequest, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(ReleasePrepareRequest prepareRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(prepareRequest.getReleaseManagerListener(), "prepare", 11);
        ReleaseDescriptor config = BooleanUtils.isNotFalse((Boolean)prepareRequest.getResume()) ? this.loadReleaseDescriptor(prepareRequest.getReleaseDescriptor(), prepareRequest.getReleaseManagerListener()) : prepareRequest.getReleaseDescriptor();
        String completedPhase = config.getCompletedPhase();
        int index = this.preparePhases.indexOf(completedPhase);
        for (int idx = 0; idx <= index; ++idx) {
            this.updateListener(prepareRequest.getReleaseManagerListener(), this.preparePhases.get(idx), 0);
        }
        if (index == this.preparePhases.size() - 1) {
            this.logInfo(result, "Release preparation already completed. You can now continue with release:perform, or start again using the -Dresume=false flag");
        } else if (index >= 0) {
            this.logInfo(result, "Resuming release from phase '" + this.preparePhases.get(index + 1) + "'");
        }
        for (int i = index + 1; i < this.preparePhases.size(); ++i) {
            String name = this.preparePhases.get(i);
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(prepareRequest.getReleaseManagerListener(), name, 1);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue((Boolean)prepareRequest.getDryRun()) ? phase.simulate(config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects()) : phase.execute(config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            config.setCompletedPhase(name);
            try {
                this.configStore.write(config);
            }
            catch (ReleaseDescriptorStoreException e) {
                throw new ReleaseExecutionException("Error writing release properties after completing phase", e);
            }
            this.updateListener(prepareRequest.getReleaseManagerListener(), name, 2);
        }
        this.updateListener(prepareRequest.getReleaseManagerListener(), "prepare", 12);
    }

    @Override
    public void rollback(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, releaseEnvironment, reactorProjects, null);
    }

    @Override
    public void rollback(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseRollbackRequest rollbackRequest = new ReleaseRollbackRequest();
        rollbackRequest.setReleaseDescriptor(releaseDescriptor);
        rollbackRequest.setReleaseEnvironment(releaseEnvironment);
        rollbackRequest.setReactorProjects(reactorProjects);
        rollbackRequest.setReleaseManagerListener(listener);
        this.rollback(rollbackRequest);
    }

    @Override
    public void rollback(ReleaseRollbackRequest rollbackRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(rollbackRequest.getReleaseManagerListener(), "rollback", 11);
        ReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(rollbackRequest.getReleaseDescriptor(), null);
        for (String name : this.rollbackPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(rollbackRequest.getReleaseManagerListener(), name, 1);
            phase.execute(releaseDescriptor, rollbackRequest.getReleaseEnvironment(), rollbackRequest.getReactorProjects());
            this.updateListener(rollbackRequest.getReleaseManagerListener(), name, 2);
        }
        this.clean(releaseDescriptor, rollbackRequest.getReleaseManagerListener(), rollbackRequest.getReactorProjects());
        this.updateListener(rollbackRequest.getReleaseManagerListener(), "rollback", 12);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, null, true);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, null, clean);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, true);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseManagerListener listener, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, new ReleaseResult(), clean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult performWithResult(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseManagerListener listener) {
        ReleaseResult result = new ReleaseResult();
        try {
            result.setStartTime(System.currentTimeMillis());
            this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, result, true);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException e) {
            this.captureException(result, listener, e);
        }
        catch (ReleaseFailureException e) {
            this.captureException(result, listener, e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void perform(ReleasePerformRequest performRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(performRequest, new ReleaseResult());
    }

    private void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, ReleaseManagerListener listener, ReleaseResult result, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        ReleasePerformRequest performRequest = new ReleasePerformRequest();
        performRequest.setReleaseDescriptor(releaseDescriptor);
        performRequest.setReleaseEnvironment(releaseEnvironment);
        performRequest.setReactorProjects(reactorProjects);
        performRequest.setReleaseManagerListener(listener);
        performRequest.setClean(clean);
        this.perform(performRequest, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(ReleasePerformRequest performRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(performRequest.getReleaseManagerListener(), "perform", 11);
        ReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(performRequest.getReleaseDescriptor(), performRequest.getReleaseManagerListener());
        for (String name : this.performPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(performRequest.getReleaseManagerListener(), name, 1);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue((Boolean)performRequest.getDryRun()) ? phase.simulate(releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects()) : phase.execute(releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            this.updateListener(performRequest.getReleaseManagerListener(), name, 2);
        }
        if (BooleanUtils.isNotFalse((Boolean)performRequest.getClean())) {
            this.clean(releaseDescriptor, performRequest.getReleaseManagerListener(), performRequest.getReactorProjects());
        }
        this.updateListener(performRequest.getReleaseManagerListener(), "perform", 12);
    }

    @Override
    public void branch(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, releaseEnvironment, reactorProjects, dryRun, null);
    }

    @Override
    public void branch(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseBranchRequest branchRequest = new ReleaseBranchRequest();
        branchRequest.setReleaseDescriptor(releaseDescriptor);
        branchRequest.setReleaseEnvironment(releaseEnvironment);
        branchRequest.setReactorProjects(reactorProjects);
        branchRequest.setDryRun(dryRun);
        branchRequest.setReleaseManagerListener(listener);
        this.branch(branchRequest);
    }

    @Override
    public void branch(ReleaseBranchRequest branchRequest) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(branchRequest.getReleaseDescriptor(), branchRequest.getReleaseManagerListener());
        this.updateListener(branchRequest.getReleaseManagerListener(), "branch", 11);
        boolean dryRun = BooleanUtils.isTrue((Boolean)branchRequest.getDryRun());
        for (String name : this.branchPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(branchRequest.getReleaseManagerListener(), name, 1);
            if (dryRun) {
                phase.simulate(releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            } else {
                phase.execute(releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            }
            this.updateListener(branchRequest.getReleaseManagerListener(), name, 2);
        }
        if (!dryRun) {
            this.clean(releaseDescriptor, branchRequest.getReleaseManagerListener(), branchRequest.getReactorProjects());
        }
        this.updateListener(branchRequest.getReleaseManagerListener(), "branch", 12);
    }

    @Override
    public void updateVersions(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseUpdateVersionsRequest updateVersionsRequest = new ReleaseUpdateVersionsRequest();
        updateVersionsRequest.setReleaseDescriptor(releaseDescriptor);
        updateVersionsRequest.setReleaseEnvironment(releaseEnvironment);
        updateVersionsRequest.setReactorProjects(reactorProjects);
        this.updateVersions(updateVersionsRequest);
    }

    @Override
    public void updateVersions(ReleaseUpdateVersionsRequest updateVersionsRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(updateVersionsRequest.getReleaseManagerListener(), "updateVersions", 11);
        ReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(updateVersionsRequest.getReleaseDescriptor(), updateVersionsRequest.getReleaseManagerListener());
        for (String name : this.updateVersionsPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(updateVersionsRequest.getReleaseManagerListener(), name, 1);
            phase.execute(releaseDescriptor, updateVersionsRequest.getReleaseEnvironment(), updateVersionsRequest.getReactorProjects());
            this.updateListener(updateVersionsRequest.getReleaseManagerListener(), name, 2);
        }
        this.clean(releaseDescriptor, updateVersionsRequest.getReleaseManagerListener(), updateVersionsRequest.getReactorProjects());
        this.updateListener(updateVersionsRequest.getReleaseManagerListener(), "updateVersions", 12);
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        if (StringUtils.isNotEmpty((String)relativePathProjectDirectory)) {
            return new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return checkoutDirectory;
    }

    private ReleaseDescriptor loadReleaseDescriptor(ReleaseDescriptor releaseDescriptor, ReleaseManagerListener listener) throws ReleaseExecutionException {
        try {
            this.updateListener(listener, "verify-release-configuration", 1);
            ReleaseDescriptor descriptor = this.configStore.read(releaseDescriptor);
            this.updateListener(listener, "verify-release-configuration", 2);
            return descriptor;
        }
        catch (ReleaseDescriptorStoreException e) {
            this.updateListener(listener, e.getMessage(), 99);
            throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), e);
        }
    }

    @Override
    public void clean(ReleaseDescriptor releaseDescriptor, ReleaseManagerListener listener, List<MavenProject> reactorProjects) {
        ReleaseCleanRequest cleanRequest = new ReleaseCleanRequest();
        cleanRequest.setReleaseDescriptor(releaseDescriptor);
        cleanRequest.setReleaseManagerListener(listener);
        cleanRequest.setReactorProjects(reactorProjects);
        this.clean(cleanRequest);
    }

    @Override
    public void clean(ReleaseCleanRequest cleanRequest) {
        this.updateListener(cleanRequest.getReleaseManagerListener(), "cleanup", 1);
        this.getLogger().info("Cleaning up after release...");
        this.configStore.delete(cleanRequest.getReleaseDescriptor());
        LinkedHashSet<String> phases = new LinkedHashSet<String>(this.preparePhases);
        phases.addAll(this.branchPhases);
        for (String name : phases) {
            ReleasePhase phase = this.releasePhases.get(name);
            phase.clean(cleanRequest.getReactorProjects());
        }
        this.updateListener(cleanRequest.getReleaseManagerListener(), "cleanup", 2);
    }

    void setConfigStore(ReleaseDescriptorStore configStore) {
        this.configStore = configStore;
    }

    void updateListener(ReleaseManagerListener listener, String name, int state) {
        if (listener != null) {
            switch (state) {
                case 11: {
                    listener.goalStart(name, this.getGoalPhases(name));
                    break;
                }
                case 12: {
                    listener.goalEnd();
                    break;
                }
                case 0: {
                    listener.phaseSkip(name);
                    break;
                }
                case 1: {
                    listener.phaseStart(name);
                    break;
                }
                case 2: {
                    listener.phaseEnd();
                    break;
                }
                default: {
                    listener.error(name);
                }
            }
        }
    }

    private List<String> getGoalPhases(String name) {
        ArrayList<String> phases = new ArrayList<String>();
        if ("prepare".equals(name)) {
            phases.addAll(this.preparePhases);
        } else if ("perform".equals(name)) {
            phases.addAll(this.performPhases);
        } else if ("rollback".equals(name)) {
            phases.addAll(this.rollbackPhases);
        } else if ("branch".equals(name)) {
            phases.addAll(this.branchPhases);
        } else if ("updateVersions".equals(name)) {
            phases.addAll(this.updateVersionsPhases);
        }
        return Collections.unmodifiableList(phases);
    }

    private void logInfo(ReleaseResult result, String message) {
        if (result != null) {
            result.appendInfo(message);
        }
        this.getLogger().info(message);
    }

    private void captureException(ReleaseResult result, ReleaseManagerListener listener, Exception e) {
        this.updateListener(listener, e.getMessage(), 99);
        result.appendError(e);
        result.setResultCode(1);
    }

    @Override
    public void branch(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, dryRun);
    }

    @Override
    public void branch(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, dryRun, listener);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    @Override
    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, clean);
    }

    @Override
    public ReleaseResult performWithResult(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, ReleaseManagerListener listener) {
        return this.performWithResult(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean resume, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun);
    }

    @Override
    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun, listener);
    }

    @Override
    public ReleaseResult prepareWithResult(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) {
        return this.prepareWithResult(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun, listener);
    }

    @Override
    public void rollback(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    @Override
    public void rollback(ReleaseDescriptor releaseDescriptor, Settings settings, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, null);
    }
}

